// E:\simPE_MPI8b_OS\OpenSource\DC_DC\FB4Q_DC_OS.c

//
static void FB4Q_DC_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, C1, IDC, L1, R1, E, TD1, TD2, TD3, TD4, Vo;


pmodel_t  
   TD1_TDModel=PMODEL, TD2_TDModel=PMODEL, TD3_TDModel=PMODEL, TD4_TDModel=PMODEL=PMODEL;


//
   SF_NAME = "FB4Q_DC_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 5 , 2 );
   C1 = cap( 4 , 3 , p[2] , p[3] );
   IDC = isc( 4 , 3 , u[5] );
   L1 = ind( 1 , 4 , p[0] , p[1] );
   R1 = res( 4 , 3 , p[4] );
   E = vsc( 5 , 0 , u[4] );
   TD1 = igbtd( 2 , 1 , u[0] , TD1_TDModel );
   TD2 = igbtd( 1 , 0 , u[1] , TD2_TDModel );
   TD3 = igbtd( 2 , 3 , u[2] , TD3_TDModel );
   TD4 = igbtd( 3 , 0 , u[3] , TD4_TDModel );
   Vo = vnn( 1 , 3 );
//
// SUB-CIRCUIT DESCRIPTION
//
//
// OUTPUT
//
   y[0]=TD1.I1;
   y[1]=TD1.I2;
   y[2]=TD3.I1;
   y[3]=TD3.I2;
   y[4]=Vo.V;
   y[5]=L1.I;
   y[6]=C1.V;
   y[7]=A1.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 2;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
   YW[5] = 1;
}
