// E:\simPE_MPI8b_OS\OpenSource\DC_DC\I2Q_DC_OS.c

//
static void I2Q_DC_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, C1, L1, R1, E, IDC, TD1, TD2;


pmodel_t  
   TD1_TDModel=PMODEL, TD2_TDModel=PMODEL=PMODEL;


//
   SF_NAME = "I2Q_DC_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 3 , 4 );
   C1 = cap( 2 , 0 , p[2] , p[3] );
   L1 = ind( 1 , 2 , p[0] , p[1] );
   R1 = res( 2 , 0 , p[4] );
   E = vsc( 3 , 0 , u[2] );
   IDC = isc( 2 , 0 , u[3] );
   TD1 = igbtd( 4 , 1 , u[0] , TD1_TDModel );
   TD2 = igbtd( 1 , 0 , u[1] , TD2_TDModel );
//
// SUB-CIRCUIT DESCRIPTION
//
//
// OUTPUT
//
   y[0]=TD1.I1;
   y[1]=TD1.I2;
   y[2]=TD2.I1;
   y[3]=TD2.I2;
   y[4]=L1.I;
   y[5]=C1.V;
   y[6]=A1.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 2;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
