// E:\simPE_MPI8b_OS\OpenSource\MMC_MC_TDY_SC.c

//
static void MMC_MC_TDY_SC (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   I1, L1, L2, L3, L4, L5, L6, S1, Va1, Vb1, Vb2, Vc1, Vc2, Va, Va2, Vb, Vc,
   VRLY1_L1, VRLY1_L2, VRLY1_L3, VRLY1_R1, VRLY1_R2, VRLY1_R3, VRLY1_R4, VRLY1_V1, 
   VRLY1_V2, VRLY1_V3, VRLY1_CB_H1, VRLY1_CB_H2, VRLY1_CB_H3, 
   VRLY1_CB_H4, VRLY1_CB_H5, VRLY1_CB_H6, VRLY1_TIDY5_1_LTp1, VRLY1_TIDY5_1_LTp2, 
   VRLY1_TIDY5_1_LTs1, VRLY1_TIDY5_1_LTp4, VRLY1_TIDY5_1_LTs2, 
   VRLY1_TIDY5_1_LTs3, VRLY1_TIDY5_1_RTp1, VRLY1_TIDY5_1_RTp2, 
   VRLY1_TIDY5_1_RTp3, VRLY1_TIDY5_1_RTs1, VRLY1_TIDY5_1_RTs2, VRLY1_TIDY5_1_RTs3, 
   VRLY1_TIDY5_1_TI1, VRLY1_TIDY5_1_TI2, VRLY1_TIDY5_1_TI4;

pmodel_t  
   S1_SModel=PMODEL,
   VRLY1_CB_H1_HModel=PMODEL, VRLY1_CB_H2_HModel=PMODEL, VRLY1_CB_H3_HModel=PMODEL, 
   VRLY1_CB_H4_HModel=PMODEL, VRLY1_CB_H5_HModel=PMODEL, VRLY1_CB_H6_HModel=PMODEL;

   S1_SModel.ron = 1e-6;
//
   SF_NAME = "MMC_MC_TDY_SC" ;
//
// CIRCUIT DESCRIPTION
//
   I1 = isc( 10 , 11 , u[9] );
   L1 = ind( 2 , 1 , p[0] , 0.0 );
   L2 = ind( 3 , 2 , p[0] , 0.0 );
   L3 = ind( 4 , 9 , p[0] , 0.0 );
   L4 = ind( 5 , 4 , p[0] , 0.0 );
   L5 = ind( 6 , 8 , p[0] , 0.0 );
   L6 = ind( 7 , 6 , p[0] , 0.0 );
   S1 = swr( 10 , 11 , u[11] , S1_SModel );
   Va1 = vsc( 10 , 1 , u[0] );
   Vb1 = vsc( 10 , 9 , u[2] );
   Vb2 = vsc( 5 , 11 , u[3] );
   Vc1 = vsc( 10 , 8 , u[4] );
   Vc2 = vsc( 7 , 11 , u[5] );
   Va = vn( 2 );
   Va2 = vsc( 3 , 11 , u[1] );
   Vb = vn( 4 );
   Vc = vn( 6 );
//
// SUB-CIRCUIT DESCRIPTION
//
   xnode(k1, 13);
   VRLY1_L1 = ind( k1[0] , k1[3] , p[1] , 0 );
   VRLY1_L2 = ind( k1[1] , k1[4] , p[1] , 0 );
   VRLY1_L3 = ind( k1[2] , k1[5] , p[1] , 0 );
   VRLY1_R1 = res( k1[3] , k1[8] , p[2] );
   VRLY1_R2 = res( k1[4] , k1[9] , p[2] );
   VRLY1_R3 = res( k1[5] , k1[10] , p[2] );
   VRLY1_R4 = res( 0 , k1[12] , p[6] );
   VRLY1_V1 = vsc( k1[0] , 0 , u[6] );
   VRLY1_V2 = vsc( k1[1] , 0 , u[7] );
   VRLY1_V3 = vsc( k1[2] , 0 , u[8] );
   VRLY1_CB_H1 = thypl( k1[8] , k1[6] , u[10] , VRLY1_CB_H1_HModel );
   VRLY1_CB_H2 = thypl( k1[6] , k1[8] , u[10] , VRLY1_CB_H2_HModel );
   VRLY1_CB_H3 = thypl( k1[9] , k1[11] , u[10] , VRLY1_CB_H3_HModel );
   VRLY1_CB_H4 = thypl( k1[11] , k1[9] , u[10] , VRLY1_CB_H4_HModel );
   VRLY1_CB_H5 = thypl( k1[10] , k1[7] , u[10] , VRLY1_CB_H5_HModel );
   VRLY1_CB_H6 = thypl( k1[7] , k1[10] , u[10] , VRLY1_CB_H6_HModel );


   xnode(k2, 12);
   VRLY1_TIDY5_1_LTp1 = ind( k1[6] , k2[1] , p[3]*3/2 , 0.0 );
   VRLY1_TIDY5_1_LTp2 = ind( k1[11] , k2[3] , p[3]*3/2 , 0.0 );
   VRLY1_TIDY5_1_LTs1 = ind( k2[0] , k2[10] , p[3]/2 , 0.0 );
   VRLY1_TIDY5_1_LTp4 = ind( k1[7] , k2[5] , p[3]*3/2 , 0.0 );
   VRLY1_TIDY5_1_LTs2 = ind( k2[7] , k2[9] , p[3]/2 , 0.0 );
   VRLY1_TIDY5_1_LTs3 = ind( k2[8] , k2[11] , p[3]/2 , 0.0 );
   VRLY1_TIDY5_1_RTp1 = res( k2[1] , k2[2] , p[4]*3/2 );
   VRLY1_TIDY5_1_RTp2 = res( k2[3] , k2[4] , p[4]*3/2 );
   VRLY1_TIDY5_1_RTp3 = res( k2[5] , k2[6] , p[4]*3/2 );
   VRLY1_TIDY5_1_RTs1 = res( k2[10] , 2 , p[4]/2 );
   VRLY1_TIDY5_1_RTs2 = res( k2[9] , 4 , p[4]/2 );
   VRLY1_TIDY5_1_RTs3 = res( k2[11] , 6 , p[4]/2 );
   VRLY1_TIDY5_1_TI1 = tfoi2( k2[4] , k1[7] , k1[12] , k2[7] , p[6] );
   VRLY1_TIDY5_1_TI2 = tfoi2( k2[6] , k1[6] , k1[12] , k2[8] , p[6] );
   VRLY1_TIDY5_1_TI4 = tfoi2( k2[2] , k1[11] , k1[12] , k2[0] , p[6] );


//
// OUTPUT
//
   y[0]=L1.I;
   y[1]=L2.I;
   y[2]=L3.I;
   y[3]=L4.I;
   y[4]=L5.I;
   y[5]=L6.I;
   y[6]=VRLY1_TIDY5_1_RTs1.I;
   y[7]=VRLY1_TIDY5_1_RTs2.I;
   y[8]=VRLY1_TIDY5_1_RTs3.I;
   y[9]=VRLY1_R1.I;
   y[10]=VRLY1_R2.I;
   y[11]=VRLY1_R3.I;
   y[12]=Va.V;
   y[13]=Vb.V;
   y[14]=Vc.V;
   y[15]=I1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 6;
   YW[1] = 3;
   YW[2] = 3;
   YW[3] = 3;
   YW[4] = 1;
}
