// E:\simPE_MPI8b_OS\OpenSource\PV_Array_Boost_PWM.c

//
static void PV_Array_Boost_PWM (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C_DC, Db, Lb, R1, R2, R3, Tb, Cpv, La1, La2, La, Vab,
   I2L_L2L1_TD1, I2L_L2L1_TD2, I2L_L2L2_TD1, I2L_L2L2_TD2, I2L_L2L3_TD1, I2L_L2L3_TD2, 
   PV_Array;

pmodel_t  
   Db_DModel=PMODEL, Tb_TModel=PMODEL,
   I2L_L2L1_TD1_TDModel=PMODEL, I2L_L2L1_TD2_TDModel=PMODEL, I2L_L2L2_TD1_TDModel=PMODEL, 
   I2L_L2L2_TD2_TDModel=PMODEL, I2L_L2L3_TD1_TDModel=PMODEL, 
   I2L_L2L3_TD2_TDModel=PMODEL;

//
   SF_NAME = "PV_Array_Boost_PWM" ;
//
// CIRCUIT DESCRIPTION
//
   C_DC = cap( 3 , 0 , p[12] , p[13] );
   Db = dpl( 2 , 3 , Db_DModel );
   Lb = ind( 1 , 2 , p[11] , 0 );
   R1 = res( 5 , 6 , p[14] );
   R2 = res( 4 , 7 , p[14] );
   R3 = res( 8 , 9 , p[14] );
   Tb = igbt( 2 , 0 , u[2] , Tb_TModel );
   Cpv = cap( 1 , 0 , p[10] , 0 );
   La1 = ind( 7 , 10 , p[15] , 0 );
   La2 = ind( 9 , 10 , p[15] , 0 );
   La = ind( 6 , 10 , p[15] , 0 );
   Vab = vnn( 5 , 4 );
//
// SUB-CIRCUIT DESCRIPTION
//
   I2L_L2L1_TD1 = igbtd( 3 , 5 , u[3] , I2L_L2L1_TD1_TDModel );
   I2L_L2L1_TD2 = igbtd( 5 , 0 , u[4] , I2L_L2L1_TD2_TDModel );
   I2L_L2L2_TD1 = igbtd( 3 , 4 , u[5] , I2L_L2L2_TD1_TDModel );
   I2L_L2L2_TD2 = igbtd( 4 , 0 , u[6] , I2L_L2L2_TD2_TDModel );
   I2L_L2L3_TD1 = igbtd( 3 , 8 , u[7] , I2L_L2L3_TD1_TDModel );
   I2L_L2L3_TD2 = igbtd( 8 , 0 , u[8] , I2L_L2L3_TD2_TDModel );


   PV_Array = PV_ARRAY( 1, 0 , 
                   p[0], p[1], u[0], p[2], p[3], p[4], u[1], p[5], p[6], p[7], p[8], p[9] );


//
// OUTPUT
//
   y[0]=PV_Array.YS[0];
   y[1]=PV_Array.YS[1];
   y[2]=Cpv.V;
   y[3]=C_DC.V;
   y[4]=La.I;
   y[5]=La1.I;
   y[6]=La2.I;
   y[7]=Vab.V;
   y[8]=I2L_L2L1_TD1.I1;
   y[9]=I2L_L2L1_TD1.I2;
   y[10]=I2L_L2L1_TD1.V1;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 3;
   YW[5] = 1;
   YW[6] = 3;
}
