/*
 * File :SELECT_MMC_C.c
 */

#define S_FUNCTION_NAME  SELECT_MMC_AFB_C
#define S_FUNCTION_LEVEL 2
#include "simstruc.h"
#include <stdlib.h>
#include <math.h> 

real_T  *UC, *UC1;
int_T *M, *Md, *M1, *IDX;

static void sort(real_T *a, real_T *b, int_T size, int_T* idx ){
    int i, j;
    real_T   temp;
    for(i = 0; i < size; i++){
        for(j = i + 1; j < size; j++){
            if(a[j] < a[i]){
                temp = a[j];
                a[j] = a[i];
                a[i] = temp;
            }                
        }
        for(j = 0; j < size; j++){
            if(a[i]==b[j])
                idx[i]=j;
        }
    }
}
   
#define U(element) (*uPtrs[element])  /* Pointer to Input Port0 */

#define PAR(S) ssGetSFcnParam(S, 0)
#define MDL_CHECK_PARAMETERS
#if defined(MDL_CHECK_PARAMETERS) && defined(MATLAB_MEX_FILE)
static void mdlCheckParameters(SimStruct *S)
{
	if (mxIsComplex(PAR(S)) || !mxIsNumeric(PAR(S)) ){
		ssSetErrorStatus(S, " Parameters must be real");
		return;
	}
}
#endif /* MDL_CHECK_PARAMETERS */


// Function: mdlInitializeSizes ===============================================

static void mdlInitializeSizes(SimStruct *S)
{
    real_T *p;

    ssSetNumSFcnParams(S, 1);  /* Number of expected parameters. */
	#if defined(MATLAB_MEX_FILE)
   	if (ssGetNumSFcnParams(S) == ssGetSFcnParamsCount(S)) {
      	mdlCheckParameters(S);
      	if (ssGetErrorStatus(S) != NULL) {
         return;
   	   }
   	}
	else {
		ssSetErrorStatus(S, " Parameters vector is empty.");
		return;
    }
	#endif
	p = mxGetPr(PAR(S));

    if (!ssSetNumInputPorts(S, 1)) return;
    ssSetInputPortWidth(S, 0, p[0]+1);
    ssSetInputPortDirectFeedThrough(S, 0, 1);

    if (!ssSetNumOutputPorts(S,1)) return;
    ssSetOutputPortWidth(S, 0, 2*p[0]);

    ssSetNumSampleTimes(S, 1);
   	ssSetNumIWork(S, 0);
	ssSetNumRWork(S, 0);	
	ssSetNumPWork(S, 2);
	
    ssSetOptions(S, SS_OPTION_EXCEPTION_FREE_CODE);
}


/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    Specifiy that we inherit our sample time from the driving block.
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, INHERITED_SAMPLE_TIME);
    ssSetOffsetTime(S, 0, 0.0);
    ssSetModelReferenceSampleTimeDefaultInheritance(S); 
}
#define MDL_START
#if defined(MDL_START)
  static void mdlStart(SimStruct *S)
  {
	real_T *p;
	
	p = mxGetPr(PAR(S));	
	M1 =(int_T *)calloc((size_t) p[0]/2, sizeof(int_T));
	Md =(int_T *)calloc((size_t) p[0]/2, sizeof(int_T));
    ssSetPWorkValue(S,1,M1);
    ssSetPWorkValue(S,2,Md);	  
  }
#endif //  MDL_START

/* Function: mdlOutputs ===================================================
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{
    int_T i, j, k, M_sum=0, SW=0;
	real_T IL;
    
    InputRealPtrsType uPtrs = ssGetInputPortRealSignalPtrs(S,0);
    real_T             *y    = ssGetOutputPortRealSignal(S,0);    
    int_T			  w_i    = ssGetInputPortWidth(S,0);
    int_T             Nc     =(w_i-1)/2;
    int_T 			  *M1    =ssGetPWorkValue(S,1);
    int_T 			  *Md    =ssGetPWorkValue(S,2);
	
	IDX =(int_T *)calloc((size_t) Nc, sizeof(int_T));
	M   =(int_T *)calloc((size_t) Nc, sizeof(int_T));
	UC  =(real_T *)calloc((size_t) Nc, sizeof(real_T));    
	UC1 =(real_T *)calloc((size_t) Nc, sizeof(real_T));    

    IL=U(2*Nc);
    for(i=0; i< Nc; i++) {
        M[i]   =(int_T)U(i);
        UC[i]  =U(Nc+i);
        UC1[i] =U(Nc+i);
        M_sum=M_sum + M[i];
    }
    for(i=0; i< Nc; i++) {
		if(M[i] !=Md[i]){
			SW=1;
			break;
		}
    }
    if(SW !=0){
		for(i=0; i< Nc; i++){
            M1[i]=0;				
		} 	
		sort(UC, UC1, Nc, IDX);			
        j=Nc-1;
        k=0;
        for(i=0; i< M_sum; i++){
            if(IL > 0){
                M1[IDX[j]]=1;
                --j;
            }
            else {
                M1[IDX[k]]=1;
                ++k;
            }
        }
	}

	for(i=0; i< Nc; i++){
        y[i*4]=M1[i];
        y[i*4+1]=!M1[i];
        y[i*4+2]=0;
        y[i*4+3]=1;
    }
	if (ssIsMajorTimeStep(S)){
		for(i=0; i< Nc; i++)
			Md[i]=M[i];
    }	
    free((char*) (IDX));
    free((char*) (M));
    free((char*) (UC));
    free((char*) (UC1));
}


/* Function: mdlTerminate =====================================================
 * Abstract:
 *    No termination needed, but we are required to have this routine.
 */
static void mdlTerminate(SimStruct *S)
{
	int_T *M1  =ssGetPWorkValue(S,1);
	int_T *Md  =ssGetPWorkValue(S,2);
	
    if (M1) 
		free (M1);
    if (Md) 
		free (Md);
}

#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
