/*
 * File :TriGen.c
 */


#define S_FUNCTION_NAME  TG_MMC
#define S_FUNCTION_LEVEL 2
#include "simstruc.h"
#include <math.h> 

#define PAR(S) ssGetSFcnParam(S, 0)
#define MDL_CHECK_PARAMETERS
#if defined(MDL_CHECK_PARAMETERS) && defined(MATLAB_MEX_FILE)

static void mdlCheckParameters(SimStruct *S)
{
	if (mxIsComplex(PAR(S)) || !mxIsNumeric(PAR(S)) )
    {
		ssSetErrorStatus(S, " Parameters must be real vector.");
		return;
	}
}
#endif /* MDL_CHECK_PARAMETERS */



/* Function: mdlInitializeSizes ===============================================
 * Abstract:
 *   Setup sizes of the various vectors.
 */
static void mdlInitializeSizes(SimStruct *S)
{
  	real_T *p;
  
    ssSetNumSFcnParams(S, 1);
    if (ssGetNumSFcnParams(S) != ssGetSFcnParamsCount(S)) {
        return; /* Parameter mismatch will be reported by Simulink */
    }

    if (!ssSetNumInputPorts(S, 0)) return;

    p = mxGetPr(PAR(S));
    if (!ssSetNumOutputPorts(S,1)) return;
    ssSetOutputPortWidth(S, 0, p[0]);

    ssSetNumSampleTimes(S, 1);

    /* Take care when specifying exception free code - see sfuntmpl_doc.c */
    ssSetOptions(S, SS_OPTION_EXCEPTION_FREE_CODE);
}


/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    Specifiy that we inherit our sample time from the driving block.
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, INHERITED_SAMPLE_TIME);
    ssSetOffsetTime(S, 0, 0.0);
    ssSetModelReferenceSampleTimeDefaultInheritance(S); 
}

/* Function: mdlOutputs =======================================================
 * Abstract:
 *    y = 2*u
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{
    int_T             i;
    real_T            *y    = ssGetOutputPortRealSignal(S,0);
    int_T             width = ssGetOutputPortWidth(S,0);
    real_T            *p, t,T, Nc, Td, tm;  
            
    p = mxGetPr(PAR(S));
    t= ssGetT(S);
    Nc=p[0];
    T =p[1];
    Td=T/Nc;
    for (i=0; i<width; i++) 
    {
        tm = fmod((t+i*Td) , T);
        y[i]=(tm* (tm <=T/4) * 4/T) +
          ((  (tm > T/4) && ( tm <=3*T/4) )* ( 1 - (tm-T/4) *4/T )) +
          (( (tm > 3*T/4)&& (tm<=T)) * ( ((tm -3*T/4)* 4/T )-1 ));      
    }
}


/* Function: mdlTerminate =====================================================
 * Abstract:
 *    No termination needed, but we are required to have this routine.
 */
static void mdlTerminate(SimStruct *S)
{
}

#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
