// E:\simPE_MPI8b_OS\OpenSource\TL\TL3PHD_OS.c

//
static void TL3PHD_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   IL1, IL2, R1, R2, R3, V1, V2, V3,
   PTL3phD_pi_tl3phd;

//
   SF_NAME = "TL3PHD_OS" ;
//
// CIRCUIT DESCRIPTION
//
   IL1 = isc( 2 , 6 , u[3] );
   IL2 = isc( 3 , 6 , u[4] );
   R1 = res( 5 , 7 , p[5] );
   R2 = res( 4 , 8 , p[5] );
   R3 = res( 1 , 9 , p[5] );
   V1 = vsc( 7 , 0 , u[0] );
   V2 = vsc( 8 , 0 , u[1] );
   V3 = vsc( 9 , 0 , u[2] );
//
// SUB-CIRCUIT DESCRIPTION
//
   PTL3phD_pi_tl3phd = PTL_3PHD( 5, 4, 1, 2, 3, 6, 0, 
                   p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7] );


//
// OUTPUT
//
   y[0]=PTL3phD_pi_tl3phd.YS[0];
   y[1]=PTL3phD_pi_tl3phd.YS[1];
   y[2]=PTL3phD_pi_tl3phd.YS[2];
   y[3]=PTL3phD_pi_tl3phd.YS[3];
   y[4]=PTL3phD_pi_tl3phd.YS[4];
   y[5]=PTL3phD_pi_tl3phd.YS[5];
   y[6]=PTL3phD_pi_tl3phd.YS[6];
   y[7]=PTL3phD_pi_tl3phd.YS[7];
   y[8]=PTL3phD_pi_tl3phd.YS[8];
   y[9]=PTL3phD_pi_tl3phd.YS[9];
   y[10]=PTL3phD_pi_tl3phd.YS[10];
   y[11]=PTL3phD_pi_tl3phd.YS[11];
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 3;
   YW[1] = 3;
   YW[2] = 3;
   YW[3] = 3;
}
