// E:\simPE_MPI8b_OS\OpenSource\DC_DC\TS_flyback_OS.c

//
static void TS_flyback_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, C1, D1, D2, D3, IDC, R1, T1, T2, E,
   mut2LI_M1;

pmodel_t  
   D1_DModel=PMODEL, D2_DModel=PMODEL, D3_DModel=PMODEL, T1_TModel=PMODEL, 
   T2_TModel=PMODEL=PMODEL;


//
   SF_NAME = "TS_flyback_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 7 , 2 );
   C1 = cap( 5 , 6 , p[3] , p[4] );
   D1 = dpl( 0 , 1 , D1_DModel );
   D2 = dpl( 3 , 2 , D2_DModel );
   D3 = dpl( 4 , 5 , D3_DModel );
   IDC = isc( 5 , 6 , u[2] );
   R1 = res( 5 , 6 , p[5] );
   T1 = igbt( 2 , 1 , u[0] , T1_TModel );
   T2 = igbt( 3 , 0 , u[0] , T2_TModel );
   E = vsc( 7 , 0 , u[1] );
//
// SUB-CIRCUIT DESCRIPTION
//
   mut2LI_M1 = mut2( 1 , 3 , 6 , 4 , p[0] , 0 , p[1] , 0 , p[2] );


//
// OUTPUT
//
   y[0]=T1.I;
   y[1]=D1.I;
   y[2]=T2.I;
   y[3]=D2.I;
   y[4]=D3.I;
   y[5]=C1.V;
   y[6]=A1.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
   YW[5] = 1;
   YW[6] = 1;
}
