// E:\simPE_MPI8b_OS\OpenSource\DC_DC\V2Q_DC_OS.c

//
static void V2Q_DC_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, C1, D1, D2, I1, L1, R1, T1, T2, V1, Vo;


pmodel_t  
   D1_DModel=PMODEL, D2_DModel=PMODEL, T1_TModel=PMODEL, T2_TModel=PMODEL=PMODEL;


//
   SF_NAME = "V2Q_DC_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 4 , 5 );
   C1 = cap( 3 , 2 , p[2] , p[3] );
   D1 = dpl( 0 , 1 , D1_DModel );
   D2 = dpl( 2 , 5 , D2_DModel );
   I1 = isc( 3 , 2 , u[2] );
   L1 = ind( 1 , 3 , p[0] , p[1] );
   R1 = res( 3 , 2 , p[4] );
   T1 = igbt( 5 , 1 , u[0] , T1_TModel );
   T2 = igbt( 2 , 0 , u[0] , T2_TModel );
   V1 = vsc( 4 , 0 , u[1] );
   Vo = vnn( 1 , 2 );
//
// SUB-CIRCUIT DESCRIPTION
//
//
// OUTPUT
//
   y[0]=T1.I;
   y[1]=D1.I;
   y[2]=T2.I;
   y[3]=D2.I;
   y[4]=Vo.V;
   y[5]=L1.I;
   y[6]=C1.V;
   y[7]=A1.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 2;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
   YW[5] = 1;
}
