// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b12d_OS.c

//
static void b12d_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, C2, I1, I2, RL1, RL2, Ld1, Ld2, Vdc1, Vdc2,
   B6D1_L2D1_D1, B6D1_L2D1_D2, B6D1_L2D2_D1, B6D1_L2D2_D2, B6D1_L2D3_D1, B6D1_L2D3_D2, 
   B6D2_L2D1_D1, B6D2_L2D1_D2, B6D2_L2D2_D1, B6D2_L2D2_D2, 
   B6D2_L2D3_D1, B6D2_L2D3_D2, TIYD5_1_LT1, TIYD5_1_LT2, TIYD5_1_LT3, 
   TIYD5_1_TI1_TI1, TIYD5_1_TI2_TI1, TIYD5_1_TI3_TI1, TIYY_1_LT1, 
   TIYY_1_LT2, TIYY_1_LT3, TIYY_1_TI1_TI1, TIYY_1_TI2_TI1, TIYY_1_TI3_TI1, 
   VRLY1_Lc1, VRLY1_Lc2, VRLY1_Lc3, VRLY1_V1, VRLY1_V2, VRLY1_V3;

pmodel_t  

   B6D1_L2D1_D1_DModel=PMODEL, B6D1_L2D1_D2_DModel=PMODEL, B6D1_L2D2_D1_DModel=PMODEL, 
   B6D1_L2D2_D2_DModel=PMODEL, B6D1_L2D3_D1_DModel=PMODEL, 
   B6D1_L2D3_D2_DModel=PMODEL, B6D2_L2D1_D1_DModel=PMODEL, B6D2_L2D1_D2_DModel=PMODEL, 
   B6D2_L2D2_D1_DModel=PMODEL, B6D2_L2D2_D2_DModel=PMODEL, 
   B6D2_L2D3_D1_DModel=PMODEL, B6D2_L2D3_D2_DModel=PMODEL;

//
   SF_NAME = "b12d_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 10 , 11 , p[6] , p[7] );
   C2 = cap( 11 , 14 , p[6] , p[7] );
   I1 = isc( 10 , 11 , u[3] );
   I2 = isc( 11 , 14 , u[4] );
   RL1 = res( 10 , 11 , p[8] );
   RL2 = res( 11 , 14 , p[8] );
   Ld1 = ind( 12 , 10 , p[4] , p[5] );
   Ld2 = ind( 14 , 13 , p[4] , p[5] );
   Vdc1 = vnn( 12 , 11 );
   Vdc2 = vnn( 11 , 13 );
//
// SUB-CIRCUIT DESCRIPTION
//
   B6D1_L2D1_D1 = dpl( 1 , 12 , B6D1_L2D1_D1_DModel );
   B6D1_L2D1_D2 = dpl( 11 , 1 , B6D1_L2D1_D2_DModel );
   B6D1_L2D2_D1 = dpl( 2 , 12 , B6D1_L2D2_D1_DModel );
   B6D1_L2D2_D2 = dpl( 11 , 2 , B6D1_L2D2_D2_DModel );
   B6D1_L2D3_D1 = dpl( 9 , 12 , B6D1_L2D3_D1_DModel );
   B6D1_L2D3_D2 = dpl( 11 , 9 , B6D1_L2D3_D2_DModel );


   B6D2_L2D1_D1 = dpl( 6 , 11 , B6D2_L2D1_D1_DModel );
   B6D2_L2D1_D2 = dpl( 13 , 6 , B6D2_L2D1_D2_DModel );
   B6D2_L2D2_D1 = dpl( 7 , 11 , B6D2_L2D2_D1_DModel );
   B6D2_L2D2_D2 = dpl( 13 , 7 , B6D2_L2D2_D2_DModel );
   B6D2_L2D3_D1 = dpl( 8 , 11 , B6D2_L2D3_D1_DModel );
   B6D2_L2D3_D2 = dpl( 13 , 8 , B6D2_L2D3_D2_DModel );


   xnode(k1, 4);
   TIYD5_1_LT1 = ind( k1[0] , 6 , p[3] , 0.0 );
   TIYD5_1_LT2 = ind( k1[1] , 7 , p[3] , 0.0 );
   TIYD5_1_LT3 = ind( k1[2] , 8 , p[3] , 0.0 );
   TIYD5_1_TI1_TI1 = tfoi2( 3 , k1[3] , k1[2] , k1[0] , p[2] );
   TIYD5_1_TI2_TI1 = tfoi2( 4 , k1[3] , k1[0] , k1[1] , p[2] );
   TIYD5_1_TI3_TI1 = tfoi2( 5 , k1[3] , k1[1] , k1[2] , p[2] );


   xnode(k1, 5);
   TIYY_1_LT1 = ind( k1[2] , 1 , p[3] , 0.0 );
   TIYY_1_LT2 = ind( k1[3] , 2 , p[3] , 0.0 );
   TIYY_1_LT3 = ind( k1[4] , 9 , p[3] , 0.0 );
   TIYY_1_TI1_TI1 = tfoi2( 3 , k1[0] , k1[2] , k1[1] , p[1] );
   TIYY_1_TI2_TI1 = tfoi2( 4 , k1[0] , k1[3] , k1[1] , p[1] );
   TIYY_1_TI3_TI1 = tfoi2( 5 , k1[0] , k1[4] , k1[1] , p[1] );


   xnode(k1, 3);
   VRLY1_Lc1 = ind( 0 , k1[0] , p[0] , 0 );
   VRLY1_Lc2 = ind( 0 , k1[1] , p[0] , 0 );
   VRLY1_Lc3 = ind( 0 , k1[2] , p[0] , 0 );
   VRLY1_V1 = vsc( 3 , k1[0] , u[0] );
   VRLY1_V2 = vsc( 4 , k1[1] , u[1] );
   VRLY1_V3 = vsc( 5 , k1[2] , u[2] );


//
// OUTPUT
//
   y[0]=B6D1_L2D1_D1.I;
   y[1]=B6D1_L2D1_D1.V;
   y[2]=B6D2_L2D1_D1.I;
   y[3]=B6D2_L2D1_D1.V;
   y[4]=VRLY1_Lc1.I;
   y[5]=VRLY1_Lc2.I;
   y[6]=VRLY1_Lc3.I;
   y[7]=Ld1.I;
   y[8]=Ld2.I;
   y[9]=Vdc1.V;
   y[10]=Vdc2.V;
   y[11]=C1.V;
   y[12]=C2.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 2;
   YW[2] = 3;
   YW[3] = 2;
   YW[4] = 2;
   YW[5] = 2;
}
