// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b12t_OS.c

//
static void b12t_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, C2, I1, I2, R1, R2, Ld1, Ld2, VDC1, VDC2,
   B6T1_L2T1_H1, B6T1_L2T1_H2, B6T1_L2T2_H1, B6T1_L2T2_H2, B6T1_L2T3_H1, B6T1_L2T3_H2, 
   B6T2_L2T1_H1, B6T2_L2T1_H2, B6T2_L2T2_H1, B6T2_L2T2_H2, 
   B6T2_L2T3_H1, B6T2_L2T3_H2, TIYD5_1_L1, TIYD5_1_L2, TIYD5_1_L3, 
   TIYD5_1_TI1_TI1, TIYD5_1_TI2_TI1, TIYD5_1_TI3_TI1, TIYY_1_L1, TIYY_1_L2, 
   TIYY_1_L3, TIYY_1_TI1_TI1, TIYY_1_TI2_TI1, TIYY_1_TI3_TI1, 
   VRLY_V1, VRLY_V2, VRLY_V3, VRLY_Ls1, VRLY_Ls2, VRLY_Ls3;

pmodel_t  

   B6T1_L2T1_H1_HModel=PMODEL, B6T1_L2T1_H2_HModel=PMODEL, B6T1_L2T2_H1_HModel=PMODEL, 
   B6T1_L2T2_H2_HModel=PMODEL, B6T1_L2T3_H1_HModel=PMODEL, 
   B6T1_L2T3_H2_HModel=PMODEL, B6T2_L2T1_H1_HModel=PMODEL, B6T2_L2T1_H2_HModel=PMODEL, 
   B6T2_L2T2_H1_HModel=PMODEL, B6T2_L2T2_H2_HModel=PMODEL, 
   B6T2_L2T3_H1_HModel=PMODEL, B6T2_L2T3_H2_HModel=PMODEL;

//
   SF_NAME = "b12t_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 12 , 10 , p[5] , p[6] );
   C2 = cap( 10 , 14 , p[5] , p[6] );
   I1 = isc( 12 , 10 , u[15] );
   I2 = isc( 10 , 14 , u[16] );
   R1 = res( 12 , 10 , p[7] );
   R2 = res( 10 , 14 , p[7] );
   Ld1 = ind( 11 , 12 , p[3] , p[4] );
   Ld2 = ind( 14 , 13 , p[3] , p[4] );
   VDC1 = vnn( 12 , 10 );
   VDC2 = vnn( 10 , 14 );
//
// SUB-CIRCUIT DESCRIPTION
//
   B6T1_L2T1_H1 = thypl( 1 , 11 , u[0] , B6T1_L2T1_H1_HModel );
   B6T1_L2T1_H2 = thypl( 10 , 1 , u[3] , B6T1_L2T1_H2_HModel );
   B6T1_L2T2_H1 = thypl( 2 , 11 , u[2] , B6T1_L2T2_H1_HModel );
   B6T1_L2T2_H2 = thypl( 10 , 2 , u[5] , B6T1_L2T2_H2_HModel );
   B6T1_L2T3_H1 = thypl( 6 , 11 , u[4] , B6T1_L2T3_H1_HModel );
   B6T1_L2T3_H2 = thypl( 10 , 6 , u[1] , B6T1_L2T3_H2_HModel );


   B6T2_L2T1_H1 = thypl( 3 , 10 , u[6] , B6T2_L2T1_H1_HModel );
   B6T2_L2T1_H2 = thypl( 13 , 3 , u[9] , B6T2_L2T1_H2_HModel );
   B6T2_L2T2_H1 = thypl( 4 , 10 , u[8] , B6T2_L2T2_H1_HModel );
   B6T2_L2T2_H2 = thypl( 13 , 4 , u[11] , B6T2_L2T2_H2_HModel );
   B6T2_L2T3_H1 = thypl( 5 , 10 , u[10] , B6T2_L2T3_H1_HModel );
   B6T2_L2T3_H2 = thypl( 13 , 5 , u[7] , B6T2_L2T3_H2_HModel );


   xnode(k1, 4);
   TIYD5_1_L1 = ind( k1[1] , 3 , p[2] , 0.0 );
   TIYD5_1_L2 = ind( k1[2] , 4 , p[2] , 0.0 );
   TIYD5_1_L3 = ind( k1[3] , 5 , p[2] , 0.0 );
   TIYD5_1_TI1_TI1 = tfoi2( 7 , k1[0] , k1[3] , k1[1] , sqrt(3) );
   TIYD5_1_TI2_TI1 = tfoi2( 8 , k1[0] , k1[1] , k1[2] , sqrt(3) );
   TIYD5_1_TI3_TI1 = tfoi2( 9 , k1[0] , k1[2] , k1[3] , sqrt(3) );


   xnode(k1, 5);
   TIYY_1_L1 = ind( k1[2] , 1 , p[1] , 0.0 );
   TIYY_1_L2 = ind( k1[3] , 2 , p[1] , 0.0 );
   TIYY_1_L3 = ind( k1[4] , 6 , p[1] , 0.0 );
   TIYY_1_TI1_TI1 = tfoi2( 7 , k1[0] , k1[2] , k1[1] , 1 );
   TIYY_1_TI2_TI1 = tfoi2( 8 , k1[0] , k1[3] , k1[1] , 1 );
   TIYY_1_TI3_TI1 = tfoi2( 9 , k1[0] , k1[4] , k1[1] , 1 );


   xnode(k1, 3);
   VRLY_V1 = vsc( k1[0] , 0 , u[12] );
   VRLY_V2 = vsc( k1[1] , 0 , u[13] );
   VRLY_V3 = vsc( k1[2] , 0 , u[14] );
   VRLY_Ls1 = ind( k1[0] , 7 , p[0] , 0 );
   VRLY_Ls2 = ind( k1[1] , 8 , p[0] , 0 );
   VRLY_Ls3 = ind( k1[2] , 9 , p[0] , 0 );


//
// OUTPUT
//
   y[0]=B6T1_L2T1_H1.I;
   y[1]=B6T1_L2T1_H1.V;
   y[2]=B6T2_L2T1_H1.I;
   y[3]=B6T2_L2T1_H1.V;
   y[4]=VRLY_Ls1.I;
   y[5]=VRLY_Ls2.I;
   y[6]=VRLY_Ls3.I;
   y[7]=Ld1.I;
   y[8]=Ld2.I;
   y[9]=VDC1.V;
   y[10]=VDC2.V;
   y[11]=C1.V;
   y[12]=C2.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 2;
   YW[2] = 3;
   YW[3] = 2;
   YW[4] = 2;
   YW[5] = 2;
}
