// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b2d_OS.c

//
static void b2d_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, IDC, R1, Lc, Ld, VDC, Vs,
   B2D_L2D1_D1, B2D_L2D1_D2, B2D_L2D2_D1, B2D_L2D2_D2;

pmodel_t  

   B2D_L2D1_D1_DModel=PMODEL, B2D_L2D1_D2_DModel=PMODEL, B2D_L2D2_D1_DModel=PMODEL, 
   B2D_L2D2_D2_DModel=PMODEL;

//
   SF_NAME = "b2d_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 4 , 3 , p[3] , p[4] );
   IDC = isc( 4 , 3 , u[1] );
   R1 = res( 4 , 3 , p[5] );
   Lc = ind( 1 , 2 , p[0] , 0 );
   Ld = ind( 5 , 4 , p[1] , p[2] );
   VDC = vnn( 5 , 3 );
   Vs = vsc( 1 , 0 , u[0] );
//
// SUB-CIRCUIT DESCRIPTION
//
   B2D_L2D1_D1 = dpl( 2 , 5 , B2D_L2D1_D1_DModel );
   B2D_L2D1_D2 = dpl( 3 , 2 , B2D_L2D1_D2_DModel );
   B2D_L2D2_D1 = dpl( 0 , 5 , B2D_L2D2_D1_DModel );
   B2D_L2D2_D2 = dpl( 3 , 0 , B2D_L2D2_D2_DModel );


//
// OUTPUT
//
   y[0]=B2D_L2D1_D1.I;
   y[1]=B2D_L2D1_D1.V;
   y[2]=Lc.I;
   y[3]=Ld.I;
   y[4]=VDC.V;
   y[5]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
