// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b2d_Trafo_OS.c

//
static void b2d_Trafo_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, I1, Ld, VDC, Vs,
   B2D1_L2D1_D1, B2D1_L2D1_D2, B2D1_L2D2_D1, B2D1_L2D2_D2, T_L1, T_L2, T_L3, 
   T_R1, T_R2, T_R3, T_TI1;

pmodel_t  

   B2D1_L2D1_D1_DModel=PMODEL, B2D1_L2D1_D2_DModel=PMODEL, B2D1_L2D2_D1_DModel=PMODEL, 
   B2D1_L2D2_D2_DModel=PMODEL;

//
   SF_NAME = "b2d_Trafo_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 4 , 3 , p[9] , p[10] );
   I1 = isc( 4 , 3 , u[1] );
   Ld = ind( 5 , 4 , p[7] , p[8] );
   VDC = vnn( 5 , 3 );
   Vs = vsc( 1 , 0 , u[0] );
//
// SUB-CIRCUIT DESCRIPTION
//
   B2D1_L2D1_D1 = dpl( 2 , 5 , B2D1_L2D1_D1_DModel );
   B2D1_L2D1_D2 = dpl( 3 , 2 , B2D1_L2D1_D2_DModel );
   B2D1_L2D2_D1 = dpl( 6 , 5 , B2D1_L2D2_D1_DModel );
   B2D1_L2D2_D2 = dpl( 3 , 6 , B2D1_L2D2_D2_DModel );


   xnode(k1, 4);
   T_L1 = ind( 1 , k1[2] , p[1] , 0.0 );
   T_L2 = ind( k1[1] , k1[3] , p[3] , 0.0 );
   T_L3 = ind( k1[0] , 0 , p[5] , 0 );
   T_R1 = res( k1[2] , k1[0] , p[0] );
   T_R2 = res( k1[3] , 2 , p[2] );
   T_R3 = res( k1[0] , 0 , p[4] );
   T_TI1 = tfoi2( k1[0] , 0 , k1[1] , 6 , p[6] );


//
// OUTPUT
//
   y[0]=B2D1_L2D1_D1.I;
   y[1]=B2D1_L2D1_D1.V;
   y[2]=T_R1.I;
   y[3]=Ld.I;
   y[4]=VDC.V;
   y[5]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
   YW[5] = 1;
}
