// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b2t_OS.c

//
static void b2t_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, H1, H2, H3, H4, R1, V1, IDC, Ld1, Lc, VDC;


pmodel_t  
   H1_HModel=PMODEL, H2_HModel=PMODEL, H3_HModel=PMODEL, H4_HModel=PMODEL=PMODEL;


//
   SF_NAME = "b2t_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 5 , 3 , p[3] , p[4] );
   H1 = thypl( 2 , 4 , u[0] , H1_HModel );
   H2 = thypl( 3 , 2 , u[1] , H2_HModel );
   H3 = thypl( 0 , 4 , u[1] , H3_HModel );
   H4 = thypl( 3 , 0 , u[0] , H4_HModel );
   R1 = res( 5 , 3 , p[5] );
   V1 = vsc( 1 , 0 , u[2] );
   IDC = isc( 5 , 3 , u[3] );
   Ld1 = ind( 4 , 5 , p[1] , p[2] );
   Lc = ind( 1 , 2 , p[0] , 0 );
   VDC = vnn( 4 , 3 );
//
// SUB-CIRCUIT DESCRIPTION
//
//
// OUTPUT
//
   y[0]=H1.I;
   y[1]=H1.V;
   y[2]=Lc.I;
   y[3]=Ld1.I;
   y[4]=VDC.V;
   y[5]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
