// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b2t_TRafo_OS.c

//
static void b2t_TRafo_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, I1, V1, Ld, VDC,
   B2T1_LT1_H1, B2T1_LT1_H2, B2T1_LT2_H1, B2T1_LT2_H2, T_L1, T_L2, T_L3, T_R1, 
   T_R2, T_R3, T_TI1;

pmodel_t  

   B2T1_LT1_H1_HModel=PMODEL, B2T1_LT1_H2_HModel=PMODEL, B2T1_LT2_H1_HModel=PMODEL, 
   B2T1_LT2_H2_HModel=PMODEL;

//
   SF_NAME = "b2t_TRafo_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 5 , 3 , p[9] , p[10] );
   I1 = isc( 5 , 3 , u[3] );
   V1 = vsc( 1 , 0 , u[2] );
   Ld = ind( 4 , 5 , p[7] , p[8] );
   VDC = vnn( 4 , 3 );
//
// SUB-CIRCUIT DESCRIPTION
//
   B2T1_LT1_H1 = thypl( 2 , 4 , u[0] , B2T1_LT1_H1_HModel );
   B2T1_LT1_H2 = thypl( 3 , 2 , u[1] , B2T1_LT1_H2_HModel );
   B2T1_LT2_H1 = thypl( 6 , 4 , u[1] , B2T1_LT2_H1_HModel );
   B2T1_LT2_H2 = thypl( 3 , 6 , u[0] , B2T1_LT2_H2_HModel );


   xnode(k1, 4);
   T_L1 = ind( 1 , k1[2] , p[1] , 0.0 );
   T_L2 = ind( k1[1] , k1[3] , p[3] , 0.0 );
   T_L3 = ind( k1[0] , 0 , p[5] , 0 );
   T_R1 = res( k1[2] , k1[0] , p[0] );
   T_R2 = res( k1[3] , 2 , p[2] );
   T_R3 = res( k1[0] , 0 , p[4] );
   T_TI1 = tfoi2( k1[0] , 0 , k1[1] , 6 , p[6] );


//
// OUTPUT
//
   y[0]=B2T1_LT1_H1.I;
   y[1]=B2T1_LT1_H1.V;
   y[2]=T_R1.I;
   y[3]=Ld.I;
   y[4]=VDC.V;
   y[5]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
