// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b6d_OS.c

//
static void b6d_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, R1, IDC, Ld, VDC,
   B6D_L2D1_D1, B6D_L2D1_D2, B6D_L2D2_D1, B6D_L2D2_D2, B6D_L2D3_D1, B6D_L2D3_D2, 
   VRLY_Lc1, VRLY_V1, VRLY_V2, VRLY_V3, VRLY_Lc2, VRLY_Lc3;

pmodel_t  

   B6D_L2D1_D1_DModel=PMODEL, B6D_L2D1_D2_DModel=PMODEL, B6D_L2D2_D1_DModel=PMODEL, 
   B6D_L2D2_D2_DModel=PMODEL, B6D_L2D3_D1_DModel=PMODEL, B6D_L2D3_D2_DModel=PMODEL;

//
   SF_NAME = "b6d_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 5 , 1 , p[3] , p[4] );
   R1 = res( 5 , 1 , p[5] );
   IDC = isc( 5 , 1 , u[3] );
   Ld = ind( 6 , 5 , p[1] , p[2] );
   VDC = vnn( 6 , 1 );
//
// SUB-CIRCUIT DESCRIPTION
//
   B6D_L2D1_D1 = dpl( 2 , 6 , B6D_L2D1_D1_DModel );
   B6D_L2D1_D2 = dpl( 1 , 2 , B6D_L2D1_D2_DModel );
   B6D_L2D2_D1 = dpl( 3 , 6 , B6D_L2D2_D1_DModel );
   B6D_L2D2_D2 = dpl( 1 , 3 , B6D_L2D2_D2_DModel );
   B6D_L2D3_D1 = dpl( 4 , 6 , B6D_L2D3_D1_DModel );
   B6D_L2D3_D2 = dpl( 1 , 4 , B6D_L2D3_D2_DModel );


   xnode(k1, 3);
   VRLY_Lc1 = ind( 0 , k1[0] , p[0] , 0 );
   VRLY_V1 = vsc( 2 , k1[0] , u[0] );
   VRLY_V2 = vsc( 3 , k1[1] , u[1] );
   VRLY_V3 = vsc( 4 , k1[2] , u[2] );
   VRLY_Lc2 = ind( 0 , k1[1] , p[0] , 0 );
   VRLY_Lc3 = ind( 0 , k1[2] , p[0] , 0 );


//
// OUTPUT
//
   y[0]=B6D_L2D1_D1.I;
   y[1]=B6D_L2D1_D1.V;
   y[2]=VRLY_Lc1.I;
   y[3]=VRLY_Lc2.I;
   y[4]=VRLY_Lc3.I;
   y[5]=Ld.I;
   y[6]=VDC.V;
   y[7]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
