// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b6d_TYD_OS.c

//
static void b6d_TYD_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, I5, Ld, R1, VDC,
   TIYD5_3PH_L1, TIYD5_3PH_L2, TIYD5_3PH_L3, TIYD5_3PH_TI1_TI1, TIYD5_3PH_TI2_TI1, 
   TIYD5_3PH_TI_TI1, VRLY1_L1, VRLY1_L2, VRLY1_L3, VRLY1_V1, 
   VRLY1_V2, VRLY1_V3, B6D1_L2D1_D1, B6D1_L2D1_D2, B6D1_L2D2_D1, B6D1_L2D2_D2, 
   B6D1_L2D3_D1, B6D1_L2D3_D2;

pmodel_t  

   B6D1_L2D1_D1_DModel=PMODEL, B6D1_L2D1_D2_DModel=PMODEL, B6D1_L2D2_D1_DModel=PMODEL, 
   B6D1_L2D2_D2_DModel=PMODEL, B6D1_L2D3_D1_DModel=PMODEL, 
   B6D1_L2D3_D2_DModel=PMODEL;

//
   SF_NAME = "b6d_TYD_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 9 , 4 , p[5] , p[6] );
   I5 = isc( 9 , 4 , u[3] );
   Ld = ind( 8 , 9 , p[3] , p[4] );
   R1 = res( 9 , 4 , p[7] );
   VDC = vnn( 8 , 4 );
//
// SUB-CIRCUIT DESCRIPTION
//
   xnode(k1, 3);
   TIYD5_3PH_L1 = ind( k1[0] , 6 , p[2] , 0.0 );
   TIYD5_3PH_L2 = ind( k1[1] , 5 , p[2] , 0.0 );
   TIYD5_3PH_L3 = ind( k1[2] , 7 , p[2] , 0.0 );
   TIYD5_3PH_TI1_TI1 = tfoi2( 1 , 0 , k1[0] , k1[1] , p[1] );
   TIYD5_3PH_TI2_TI1 = tfoi2( 3 , 0 , k1[1] , k1[2] , p[1] );
   TIYD5_3PH_TI_TI1 = tfoi2( 2 , 0 , k1[2] , k1[0] , p[1] );


   xnode(k1, 3);
   VRLY1_L1 = ind( k1[0] , 0 , p[0] , 0.0 );
   VRLY1_L2 = ind( k1[1] , 0 , p[0] , 0.0 );
   VRLY1_L3 = ind( k1[2] , 0 , p[0] , 0.0 );
   VRLY1_V1 = vsc( 2 , k1[0] , u[0] );
   VRLY1_V2 = vsc( 1 , k1[1] , u[1] );
   VRLY1_V3 = vsc( 3 , k1[2] , u[2] );


   B6D1_L2D1_D1 = dpl( 6 , 8 , B6D1_L2D1_D1_DModel );
   B6D1_L2D1_D2 = dpl( 4 , 6 , B6D1_L2D1_D2_DModel );
   B6D1_L2D2_D1 = dpl( 5 , 8 , B6D1_L2D2_D1_DModel );
   B6D1_L2D2_D2 = dpl( 4 , 5 , B6D1_L2D2_D2_DModel );
   B6D1_L2D3_D1 = dpl( 7 , 8 , B6D1_L2D3_D1_DModel );
   B6D1_L2D3_D2 = dpl( 4 , 7 , B6D1_L2D3_D2_DModel );


//
// OUTPUT
//
   y[0]=B6D1_L2D1_D1.I;
   y[1]=B6D1_L2D1_D1.V;
   y[2]=VRLY1_L1.I;
   y[3]=VRLY1_L2.I;
   y[4]=VRLY1_L3.I;
   y[5]=Ld.I;
   y[6]=VDC.V;
   y[7]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
