// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b6d_TYY_OS.c

//
static void b6d_TYY_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, I5, R1, Ld, RL, VDC,
   B6D1_L2D1_D1, B6D1_L2D1_D2, B6D1_L2D2_D1, B6D1_L2D2_D2, B6D1_L2D3_D1, B6D1_L2D3_D2, 
   TIYY0_3PH_RT1, TIYY0_3PH_RT2, TIYY0_3PH_RT, TIYY0_3PH_TI1_TI1, 
   TIYY0_3PH_TI2_TI1, TIYY0_3PH_TI3_TI1, VRLY1_L1, VRLY1_L2, 
   VRLY1_L3, VRLY1_V1, VRLY1_V2, VRLY1_V3;

pmodel_t  

   B6D1_L2D1_D1_DModel=PMODEL, B6D1_L2D1_D2_DModel=PMODEL, B6D1_L2D2_D1_DModel=PMODEL, 
   B6D1_L2D2_D2_DModel=PMODEL, B6D1_L2D3_D1_DModel=PMODEL, 
   B6D1_L2D3_D2_DModel=PMODEL;

//
   SF_NAME = "b6d_TYY_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 3 , 2 , p[5] , p[6] );
   I5 = isc( 3 , 2 , u[3] );
   R1 = res( 0 , 10 , 1e5 );
   Ld = ind( 7 , 3 , p[3] , p[4] );
   RL = res( 3 , 2 , p[7] );
   VDC = vnn( 7 , 2 );
//
// SUB-CIRCUIT DESCRIPTION
//
   B6D1_L2D1_D1 = dpl( 4 , 7 , B6D1_L2D1_D1_DModel );
   B6D1_L2D1_D2 = dpl( 2 , 4 , B6D1_L2D1_D2_DModel );
   B6D1_L2D2_D1 = dpl( 5 , 7 , B6D1_L2D2_D1_DModel );
   B6D1_L2D2_D2 = dpl( 2 , 5 , B6D1_L2D2_D2_DModel );
   B6D1_L2D3_D1 = dpl( 6 , 7 , B6D1_L2D3_D1_DModel );
   B6D1_L2D3_D2 = dpl( 2 , 6 , B6D1_L2D3_D2_DModel );


   xnode(k1, 3);
   TIYY0_3PH_RT1 = res( k1[1] , 5 , p[2] );
   TIYY0_3PH_RT2 = res( k1[2] , 6 , p[2] );
   TIYY0_3PH_RT = res( k1[0] , 4 , p[2] );
   TIYY0_3PH_TI1_TI1 = tfoi2( 1 , 0 , k1[0] , 10 , p[1] );
   TIYY0_3PH_TI2_TI1 = tfoi2( 8 , 0 , k1[1] , 10 , p[1] );
   TIYY0_3PH_TI3_TI1 = tfoi2( 9 , 0 , k1[2] , 10 , p[1] );


   xnode(k1, 3);
   VRLY1_L1 = ind( 0 , k1[0] , p[0] , 0.0 );
   VRLY1_L2 = ind( 0 , k1[1] , p[0] , 0.0 );
   VRLY1_L3 = ind( 0 , k1[2] , p[0] , 0.0 );
   VRLY1_V1 = vsc( 1 , k1[0] , u[0] );
   VRLY1_V2 = vsc( 8 , k1[1] , u[1] );
   VRLY1_V3 = vsc( 9 , k1[2] , u[2] );


//
// OUTPUT
//
   y[0]=B6D1_L2D1_D1.I;
   y[1]=B6D1_L2D1_D1.V;
   y[2]=VRLY1_L1.I;
   y[3]=VRLY1_L2.I;
   y[4]=VRLY1_L3.I;
   y[5]=Ld.I;
   y[6]=VDC.V;
   y[7]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
