// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b6t_OS.c

//
static void b6t_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, H1, H3, H5, H4, H2, H6, R1, IDC, Ld, VDC,
   VRLY_L1, VRLY_L2, VRLY_L3, VRLY_V1, VRLY_V2, VRLY_V3;

pmodel_t  
   H1_HModel=PMODEL, H3_HModel=PMODEL, H5_HModel=PMODEL, H4_HModel=PMODEL, 
   H2_HModel=PMODEL, H6_HModel=PMODEL=PMODEL;


//
   SF_NAME = "b6t_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 4 , 2 , p[3] , p[4] );
   H1 = thypl( 1 , 3 , u[0] , H1_HModel );
   H3 = thypl( 5 , 3 , u[2] , H3_HModel );
   H5 = thypl( 6 , 3 , u[4] , H5_HModel );
   H4 = thypl( 2 , 1 , u[3] , H4_HModel );
   H2 = thypl( 2 , 6 , u[1] , H2_HModel );
   H6 = thypl( 2 , 5 , u[5] , H6_HModel );
   R1 = res( 4 , 2 , p[5] );
   IDC = isc( 4 , 2 , u[9] );
   Ld = ind( 3 , 4 , p[1] , p[2] );
   VDC = vnn( 3 , 2 );
//
// SUB-CIRCUIT DESCRIPTION
//
   xnode(k1, 3);
   VRLY_L1 = ind( k1[0] , 0 , p[0] , 0 );
   VRLY_L2 = ind( k1[1] , 0 , p[0] , 0 );
   VRLY_L3 = ind( k1[2] , 0 , p[0] , 0 );
   VRLY_V1 = vsc( 1 , k1[0] , u[6] );
   VRLY_V2 = vsc( 5 , k1[1] , u[7] );
   VRLY_V3 = vsc( 6 , k1[2] , u[8] );


//
// OUTPUT
//
   y[0]=H1.I;
   y[1]=H1.V;
   y[2]=VRLY_L1.I;
   y[3]=VRLY_L2.I;
   y[4]=VRLY_L3.I;
   y[5]=Ld.I;
   y[6]=VDC.V;
   y[7]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 2;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 1;
   YW[4] = 1;
}
