// E:\simPE_MPI8b_OS\OpenSource\AC_DC\b6t_TYY_OS.c

//
static void b6t_TYY_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, I5, R1, Ld, VDC, Vab,
   B6T1_L2T1_H1, B6T1_L2T1_H2, B6T1_L2T2_H1, B6T1_L2T2_H2, B6T1_L2T3_H1, B6T1_L2T3_H2, 
   TYY6_3PH_T1_R3, TYY6_3PH_T1_L1, TYY6_3PH_T1_L2, TYY6_3PH_T1_L3, 
   TYY6_3PH_T1_R1, TYY6_3PH_T1_R2, TYY6_3PH_T1_TI1, TYY6_3PH_T2_R3, 
   TYY6_3PH_T2_L1, TYY6_3PH_T2_L2, TYY6_3PH_T2_L3, TYY6_3PH_T2_R1, 
   TYY6_3PH_T2_R2, TYY6_3PH_T2_TI1, TYY6_3PH_T_R3, TYY6_3PH_T_L1, 
   TYY6_3PH_T_L2, TYY6_3PH_T_L3, TYY6_3PH_T_R1, TYY6_3PH_T_R2, TYY6_3PH_T_TI1, 
   VRLY1_V1, VRLY1_V2, VRLY1_V3, VRLY1_RLS1_rls, VRLY1_RLS2_rls, 
   VRLY1_RLS3_rls;

pmodel_t  

   B6T1_L2T1_H1_HModel=PMODEL, B6T1_L2T1_H2_HModel=PMODEL, B6T1_L2T2_H1_HModel=PMODEL, 
   B6T1_L2T2_H2_HModel=PMODEL, B6T1_L2T3_H1_HModel=PMODEL, 
   B6T1_L2T3_H2_HModel=PMODEL;

//
   SF_NAME = "b6t_TYY_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 5 , 4 , p[9] , p[10] );
   I5 = isc( 5 , 4 , u[3] );
   R1 = res( 0 , 10 , 1e6 );
   Ld = ind( 9 , 5 , p[3] , p[4] );
   VDC = vnn( 9 , 4 );
   Vab = vnn( 7 , 6 );
//
// SUB-CIRCUIT DESCRIPTION
//
   B6T1_L2T1_H1 = thypl( 7 , 9 , u[0] , B6T1_L2T1_H1_HModel );
   B6T1_L2T1_H2 = thypl( 4 , 7 , u[3] , B6T1_L2T1_H2_HModel );
   B6T1_L2T2_H1 = thypl( 6 , 9 , u[2] , B6T1_L2T2_H1_HModel );
   B6T1_L2T2_H2 = thypl( 4 , 6 , u[5] , B6T1_L2T2_H2_HModel );
   B6T1_L2T3_H1 = thypl( 8 , 9 , u[4] , B6T1_L2T3_H1_HModel );
   B6T1_L2T3_H2 = thypl( 4 , 8 , u[1] , B6T1_L2T3_H2_HModel );




   xnode(k2, 4);
   TYY6_3PH_T1_R3 = res( k2[0] , 0 , p[4] );
   TYY6_3PH_T1_L1 = ind( k2[1] , k2[0] , p[1] , 0 );
   TYY6_3PH_T1_L2 = ind( k2[3] , k2[2] , p[3] , 0 );
   TYY6_3PH_T1_L3 = ind( k2[0] , 0 , p[5] , 0 );
   TYY6_3PH_T1_R1 = res( 1 , k2[1] , p[0] );
   TYY6_3PH_T1_R2 = res( k2[2] , 10 , p[2] );
   TYY6_3PH_T1_TI1 = tfoi2( k2[0] , 0 , k2[3] , 6 , p[6] );


   xnode(k2, 4);
   TYY6_3PH_T2_R3 = res( k2[0] , 0 , p[4] );
   TYY6_3PH_T2_L1 = ind( k2[1] , k2[0] , p[1] , 0 );
   TYY6_3PH_T2_L2 = ind( k2[3] , k2[2] , p[3] , 0 );
   TYY6_3PH_T2_L3 = ind( k2[0] , 0 , p[5] , 0 );
   TYY6_3PH_T2_R1 = res( 3 , k2[1] , p[0] );
   TYY6_3PH_T2_R2 = res( k2[2] , 10 , p[2] );
   TYY6_3PH_T2_TI1 = tfoi2( k2[0] , 0 , k2[3] , 8 , p[6] );


   xnode(k2, 4);
   TYY6_3PH_T_R3 = res( k2[0] , 0 , p[4] );
   TYY6_3PH_T_L1 = ind( k2[1] , k2[0] , p[1] , 0 );
   TYY6_3PH_T_L2 = ind( k2[3] , k2[2] , p[3] , 0 );
   TYY6_3PH_T_L3 = ind( k2[0] , 0 , p[5] , 0 );
   TYY6_3PH_T_R1 = res( 2 , k2[1] , p[0] );
   TYY6_3PH_T_R2 = res( k2[2] , 10 , p[2] );
   TYY6_3PH_T_TI1 = tfoi2( k2[0] , 0 , k2[3] , 7 , p[6] );


   xnode(k1, 3);
   VRLY1_V1 = vsc( 2 , k1[0] , u[0] );
   VRLY1_V2 = vsc( 1 , k1[1] , u[1] );
   VRLY1_V3 = vsc( 3 , k1[2] , u[2] );
   VRLY1_RLS1_rls = RLS( k1[0], 0, 
                   p[0], p[1], 0 );
   VRLY1_RLS2_rls = RLS( k1[1], 0, 
                   p[0], p[1], 0 );
   VRLY1_RLS3_rls = RLS( k1[2], 0, 
                   p[0], p[1], 0 );


//
// OUTPUT
//
   y[0]=B6T1_L2T1_H1.I;
   y[0]=TYY6_3PH_T_R1.I;
   y[0]=VRLY1_RLS1_rls.YS[0];
   y[1]=B6T1_L2T1_H1.V;
   y[1]=TYY6_3PH_T1_R1.I;
   y[1]=VRLY1_RLS2_rls.YS[0];
   y[2]=TYY6_3PH_T2_R1.I;
   y[2]=VRLY1_RLS3_rls.YS[0];
   y[3]=Vab.V;
   y[4]=C1.V;
   y[5]=Ld.I;
   y[6]=VDC.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 3;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 2;
}
