// E:\simPE_MPI8b_OS\OpenSource\DC_DC\forward_OS.c

//
static void forward_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   C1, D1, D2, D3, I1, L1, R1, T1, V1,
   mut3L;

pmodel_t  
   D1_DModel=PMODEL, D2_DModel=PMODEL, D3_DModel=PMODEL, T1_TModel=PMODEL=PMODEL;


//
   SF_NAME = "forward_OS" ;
//
// CIRCUIT DESCRIPTION
//
   C1 = cap( 6 , 0 , p[7] , p[8] );
   D1 = dpl( 1 , 2 , D1_DModel );
   D2 = dpl( 0 , 2 , D2_DModel );
   D3 = dpl( 0 , 4 , D3_DModel );
   I1 = isc( 6 , 0 , u[2] );
   L1 = ind( 2 , 6 , p[6] , 0 );
   R1 = res( 6 , 0 , p[9] );
   T1 = igbt( 3 , 0 , u[0] , T1_TModel );
   V1 = vsc( 5 , 0 , u[1] );
//
// SUB-CIRCUIT DESCRIPTION
//
   mut3L = mut3( 5, 1, 4 , 3, 0, 5 , 
                   p[0], 0, p[1], 0, p[2], 0, p[3], p[4], p[5] );


//
// OUTPUT
//
   y[0]=T1.I;
   y[1]=D1.I;
   y[2]=L1.I;
   y[3]=mut3L.YS[3];
   y[4]=mut3L.YS[4];
   y[5]=mut3L.YS[5];
   y[6]=D2.I;
   y[7]=D3.I;
   y[8]=C1.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 1;
   YW[5] = 1;
   YW[6] = 1;
}
