// E:\simPE_MPI8b_OS\OpenSource\pwm_2L_3PH_IS_OS.c

//
static void pwm_2L_3PH_IS_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, I3, I1, I2, V1, V2, Vb, Vc, Va, Vab,
   I2L_L2L1_TD1, I2L_L2L1_TD2, I2L_L2L2_TD1, I2L_L2L2_TD2, I2L_L2L3_TD1, I2L_L2L3_TD2;

pmodel_t  

   I2L_L2L1_TD1_TDModel=PMODEL, I2L_L2L1_TD2_TDModel=PMODEL, I2L_L2L2_TD1_TDModel=PMODEL, 
   I2L_L2L2_TD2_TDModel=PMODEL, I2L_L2L3_TD1_TDModel=PMODEL, 
   I2L_L2L3_TD2_TDModel=PMODEL;

//
   SF_NAME = "pwm_2L_3PH_IS_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 6 , 7 );
   I3 = am( 4 , 3 );
   I1 = isc( 1 , 3 , u[7] );
   I2 = isc( 2 , 3 , u[8] );
   V1 = vsc( 6 , 0 , u[6]/2 );
   V2 = vsc( 0 , 5 , u[6]/2 );
   Vb = vn( 2 );
   Vc = vn( 4 );
   Va = vn( 1 );
   Vab = vnn( 1 , 2 );
//
// SUB-CIRCUIT DESCRIPTION
//
   I2L_L2L1_TD1 = igbtd( 7 , 1 , u[0] , I2L_L2L1_TD1_TDModel );
   I2L_L2L1_TD2 = igbtd( 1 , 5 , u[1] , I2L_L2L1_TD2_TDModel );
   I2L_L2L2_TD1 = igbtd( 7 , 2 , u[2] , I2L_L2L2_TD1_TDModel );
   I2L_L2L2_TD2 = igbtd( 2 , 5 , u[3] , I2L_L2L2_TD2_TDModel );
   I2L_L2L3_TD1 = igbtd( 7 , 4 , u[4] , I2L_L2L3_TD1_TDModel );
   I2L_L2L3_TD2 = igbtd( 4 , 5 , u[5] , I2L_L2L3_TD2_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=Vb.V;
   y[2]=Vc.V;
   y[3]=I1.I;
   y[4]=I2.I;
   y[5]=I3.I;
   y[6]=Vab.V;
   y[7]=I2L_L2L1_TD1.I1;
   y[8]=I2L_L2L1_TD1.I2;
   y[9]=I2L_L2L1_TD1.V1;
   y[10]=A1.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 3;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 1;
}
