// E:\simPE_MPI8b_OS\OpenSource\pwm_2L_3PH_VLR_OS.c

//
static void pwm_2L_3PH_VLR_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, L1, L2, L3, R1, R2, R3, V1, V2, VL1, VL2, VL3, Vb, Vc, Va, Vab,
   I2L_L2L1_TD1, I2L_L2L1_TD2, I2L_L2L2_TD1, I2L_L2L2_TD2, I2L_L2L3_TD1, I2L_L2L3_TD2;

pmodel_t  

   I2L_L2L1_TD1_TDModel=PMODEL, I2L_L2L1_TD2_TDModel=PMODEL, I2L_L2L2_TD1_TDModel=PMODEL, 
   I2L_L2L2_TD2_TDModel=PMODEL, I2L_L2L3_TD1_TDModel=PMODEL, 
   I2L_L2L3_TD2_TDModel=PMODEL;

//
   SF_NAME = "pwm_2L_3PH_VLR_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 5 , 6 );
   L1 = ind( 7 , 8 , p[1] , 0.0 );
   L2 = ind( 9 , 13 , p[1] , 0.0 );
   L3 = ind( 11 , 12 , p[1] , 0.0 );
   R1 = res( 8 , 10 , p[0] );
   R2 = res( 13 , 10 , p[0] );
   R3 = res( 12 , 10 , p[0] );
   V1 = vsc( 5 , 0 , u[6]/2 );
   V2 = vsc( 0 , 4 , u[6]/2 );
   VL1 = vsc( 1 , 7 , u[7] );
   VL2 = vsc( 2 , 9 , u[8] );
   VL3 = vsc( 3 , 11 , u[9] );
   Vb = vn( 2 );
   Vc = vn( 3 );
   Va = vn( 1 );
   Vab = vnn( 1 , 2 );
//
// SUB-CIRCUIT DESCRIPTION
//
   I2L_L2L1_TD1 = igbtd( 6 , 1 , u[0] , I2L_L2L1_TD1_TDModel );
   I2L_L2L1_TD2 = igbtd( 1 , 4 , u[1] , I2L_L2L1_TD2_TDModel );
   I2L_L2L2_TD1 = igbtd( 6 , 2 , u[2] , I2L_L2L2_TD1_TDModel );
   I2L_L2L2_TD2 = igbtd( 2 , 4 , u[3] , I2L_L2L2_TD2_TDModel );
   I2L_L2L3_TD1 = igbtd( 6 , 3 , u[4] , I2L_L2L3_TD1_TDModel );
   I2L_L2L3_TD2 = igbtd( 3 , 4 , u[5] , I2L_L2L3_TD2_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=Vb.V;
   y[2]=Vc.V;
   y[3]=R1.I;
   y[4]=R2.I;
   y[5]=R3.I;
   y[6]=Vab.V;
   y[7]=I2L_L2L1_TD1.I1;
   y[8]=I2L_L2L1_TD1.I2;
   y[9]=I2L_L2L1_TD1.V1;
   y[10]=A1.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 3;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 1;
}
