// E:\simPE_MPI8b_OS\OpenSource\pwm_2L_HB_VLRC_OS.c

//
static void pwm_2L_HB_VLRC_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, Cf, Lf, L1, R1, Rf, V1, V2, VL1, Va,
   I2L_L2L1_TD1, I2L_L2L1_TD2;

pmodel_t  

   I2L_L2L1_TD1_TDModel=PMODEL, I2L_L2L1_TD2_TDModel=PMODEL;

//
   SF_NAME = "pwm_2L_HB_VLRC_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 3 , 4 );
   Cf = cap( 8 , 0 , p[4] , 0.0 );
   Lf = ind( 1 , 6 , p[2] , 0.0 );
   L1 = ind( 6 , 7 , p[1] , 0.0 );
   R1 = res( 7 , 5 , p[0] );
   Rf = res( 6 , 8 , p[3] );
   V1 = vsc( 3 , 0 , u[2]/2 );
   V2 = vsc( 0 , 2 , u[2]/2 );
   VL1 = vsc( 5 , 0 , u[3] );
   Va = vn( 1 );
//
// SUB-CIRCUIT DESCRIPTION
//
   I2L_L2L1_TD1 = igbtd( 4 , 1 , u[0] , I2L_L2L1_TD1_TDModel );
   I2L_L2L1_TD2 = igbtd( 1 , 2 , u[1] , I2L_L2L1_TD2_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=R1.I;
   y[2]=I2L_L2L1_TD1.I1;
   y[3]=I2L_L2L1_TD1.I2;
   y[4]=I2L_L2L1_TD1.V1;
   y[5]=A1.I;
   y[6]=Cf.V;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 3;
   YW[3] = 1;
   YW[4] = 1;
}
