// E:\simPE_MPI8b_OS\OpenSource\pwm_2L_HB_VLR_OS.c

//
static void pwm_2L_HB_VLR_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, L1, R1, V1, V2, VL1, Va,
   I2L_L2L1_TD1, I2L_L2L1_TD2;

pmodel_t  

   I2L_L2L1_TD1_TDModel=PMODEL, I2L_L2L1_TD2_TDModel=PMODEL;

//
   SF_NAME = "pwm_2L_HB_VLR_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 3 , 4 );
   L1 = ind( 5 , 6 , p[1] , 0.0 );
   R1 = res( 6 , 0 , p[0] );
   V1 = vsc( 3 , 0 , u[2]/2 );
   V2 = vsc( 0 , 2 , u[2]/2 );
   VL1 = vsc( 1 , 5 , u[3] );
   Va = vn( 1 );
//
// SUB-CIRCUIT DESCRIPTION
//
   I2L_L2L1_TD1 = igbtd( 4 , 1 , u[0] , I2L_L2L1_TD1_TDModel );
   I2L_L2L1_TD2 = igbtd( 1 , 2 , u[1] , I2L_L2L1_TD2_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=R1.I;
   y[2]=I2L_L2L1_TD1.I1;
   y[3]=I2L_L2L1_TD1.I2;
   y[4]=I2L_L2L1_TD1.V1;
   y[5]=A1.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 3;
   YW[3] = 1;
}
