// E:\simPE_MPI8b_OS\OpenSource\pwm_3LD_FB_IS_OS.c

//
static void pwm_3LD_FB_IS_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, I1, V1, V2, Va, Vab,
   I3LD_L3LD1_D5, I3LD_L3LD1_D6, I3LD_L3LD1_TD1, I3LD_L3LD1_TD2, I3LD_L3LD1_TD3, 
   I3LD_L3LD1_TD4, I3LD_L3LD2_D1, I3LD_L3LD2_D2, I3LD_L3LD2_TD1, 
   I3LD_L3LD2_TD2, I3LD_L3LD2_TD3, I3LD_L3LD2_TD4;

pmodel_t  

   I3LD_L3LD1_D5_DModel=PMODEL, I3LD_L3LD1_D6_DModel=PMODEL, I3LD_L3LD1_TD1_TDModel=PMODEL, 
   I3LD_L3LD1_TD2_TDModel=PMODEL, I3LD_L3LD1_TD3_TDModel=PMODEL, 
   I3LD_L3LD1_TD4_TDModel=PMODEL, I3LD_L3LD2_D1_DModel=PMODEL, 
   I3LD_L3LD2_D2_DModel=PMODEL, I3LD_L3LD2_TD1_TDModel=PMODEL, 
   I3LD_L3LD2_TD2_TDModel=PMODEL, I3LD_L3LD2_TD3_TDModel=PMODEL, I3LD_L3LD2_TD4_TDModel=PMODEL;

   I3LD_L3LD1_TD2_TDModel.roff = 1e5;
   I3LD_L3LD1_TD3_TDModel.roff = 1e5;
   I3LD_L3LD2_TD2_TDModel.roff = 1e5;
   I3LD_L3LD2_TD3_TDModel.roff = 1e5;
//
   SF_NAME = "pwm_3LD_FB_IS_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 3 , 4 );
   A2 = am( 6 , 5 );
   I1 = isc( 1 , 2 , u[9] );
   V1 = vsc( 3 , 0 , u[8]/2 );
   V2 = vsc( 0 , 5 , u[8]/2 );
   Va = vn( 1 );
   Vab = vnn( 1 , 2 );
//
// SUB-CIRCUIT DESCRIPTION
//


   xnode(k2, 2);
   I3LD_L3LD1_D5 = dpl( 0 , k2[0] , I3LD_L3LD1_D5_DModel );
   I3LD_L3LD1_D6 = dpl( k2[1] , 0 , I3LD_L3LD1_D6_DModel );
   I3LD_L3LD1_TD1 = igbtd( 4 , k2[0] , u[0] , I3LD_L3LD1_TD1_TDModel );
   I3LD_L3LD1_TD2 = igbtd( k2[0] , 1 , u[1] , I3LD_L3LD1_TD2_TDModel );
   I3LD_L3LD1_TD3 = igbtd( 1 , k2[1] , u[2] , I3LD_L3LD1_TD3_TDModel );
   I3LD_L3LD1_TD4 = igbtd( k2[1] , 6 , u[3] , I3LD_L3LD1_TD4_TDModel );


   xnode(k2, 2);
   I3LD_L3LD2_D1 = dpl( 0 , k2[0] , I3LD_L3LD2_D1_DModel );
   I3LD_L3LD2_D2 = dpl( k2[1] , 0 , I3LD_L3LD2_D2_DModel );
   I3LD_L3LD2_TD1 = igbtd( 4 , k2[0] , u[4] , I3LD_L3LD2_TD1_TDModel );
   I3LD_L3LD2_TD2 = igbtd( k2[0] , 2 , u[5] , I3LD_L3LD2_TD2_TDModel );
   I3LD_L3LD2_TD3 = igbtd( 2 , k2[1] , u[6] , I3LD_L3LD2_TD3_TDModel );
   I3LD_L3LD2_TD4 = igbtd( k2[1] , 6 , u[7] , I3LD_L3LD2_TD4_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=I1.I;
   y[2]=Vab.V;
   y[3]=I3LD_L3LD1_TD1.I1;
   y[4]=I3LD_L3LD1_TD1.I2;
   y[5]=I3LD_L3LD1_TD1.V1;
   y[6]=I3LD_L3LD1_TD2.I1;
   y[7]=I3LD_L3LD1_TD2.I2;
   y[8]=I3LD_L3LD1_TD2.V1;
   y[9]=I3LD_L3LD1_D5.I;
   y[10]=I3LD_L3LD1_D5.V;
   y[11]=A1.I;
   y[12]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 3;
   YW[5] = 2;
   YW[6] = 2;
}
