// E:\simPE_MPI8b_OS\OpenSource\pwm_3LD_HB_VLR_OS.c

//
static void pwm_3LD_HB_VLR_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, LL1, V1, V2, RL1, VL1, Va,
   I3LD_L3LD1_D5, I3LD_L3LD1_D6, I3LD_L3LD1_TD1, I3LD_L3LD1_TD2, I3LD_L3LD1_TD3, 
   I3LD_L3LD1_TD4;

pmodel_t  

   I3LD_L3LD1_D5_DModel=PMODEL, I3LD_L3LD1_D6_DModel=PMODEL, I3LD_L3LD1_TD1_TDModel=PMODEL, 
   I3LD_L3LD1_TD2_TDModel=PMODEL, I3LD_L3LD1_TD3_TDModel=PMODEL, 
   I3LD_L3LD1_TD4_TDModel=PMODEL;

   I3LD_L3LD1_TD2_TDModel.roff = 1e5;
   I3LD_L3LD1_TD3_TDModel.roff = 1e5;
//
   SF_NAME = "pwm_3LD_HB_VLR_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 2 , 3 );
   A2 = am( 5 , 4 );
   LL1 = ind( 6 , 7 , p[1] , 0.0 );
   V1 = vsc( 2 , 0 , u[4]/2 );
   V2 = vsc( 0 , 4 , u[4]/2 );
   RL1 = res( 0 , 7 , p[0] );
   VL1 = vsc( 1 , 6 , u[5] );
   Va = vn( 1 );
//
// SUB-CIRCUIT DESCRIPTION
//


   xnode(k2, 2);
   I3LD_L3LD1_D5 = dpl( 0 , k2[0] , I3LD_L3LD1_D5_DModel );
   I3LD_L3LD1_D6 = dpl( k2[1] , 0 , I3LD_L3LD1_D6_DModel );
   I3LD_L3LD1_TD1 = igbtd( 3 , k2[0] , u[0] , I3LD_L3LD1_TD1_TDModel );
   I3LD_L3LD1_TD2 = igbtd( k2[0] , 1 , u[1] , I3LD_L3LD1_TD2_TDModel );
   I3LD_L3LD1_TD3 = igbtd( 1 , k2[1] , u[2] , I3LD_L3LD1_TD3_TDModel );
   I3LD_L3LD1_TD4 = igbtd( k2[1] , 5 , u[3] , I3LD_L3LD1_TD4_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=RL1.I;
   y[2]=I3LD_L3LD1_TD1.I1;
   y[3]=I3LD_L3LD1_TD1.I2;
   y[4]=I3LD_L3LD1_TD1.V1;
   y[5]=I3LD_L3LD1_TD2.I1;
   y[6]=I3LD_L3LD1_TD2.I2;
   y[7]=I3LD_L3LD1_TD2.V1;
   y[8]=I3LD_L3LD1_D5.I;
   y[9]=I3LD_L3LD1_D5.V;
   y[10]=A1.I;
   y[11]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 3;
   YW[3] = 3;
   YW[4] = 2;
   YW[5] = 2;
}
