// E:\simPE_MPI8b_OS\OpenSource\pwm_3LD_OS.c

//
static void pwm_3LD_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, LL1, V1, V2, LL2, LL3, RL1, RL2, RL3, VL1, VL2, VL3, Va, Vab, Vb, 
   Vc,
   I3LD_L3LD1_D5, I3LD_L3LD1_D6, I3LD_L3LD1_R1, I3LD_L3LD1_R2, I3LD_L3LD1_TD1, 
   I3LD_L3LD1_TD2, I3LD_L3LD1_TD3, I3LD_L3LD1_TD4, I3LD_L3LD2_D1, 
   I3LD_L3LD2_D2, I3LD_L3LD2_R1, I3LD_L3LD2_R2, I3LD_L3LD2_TD1, I3LD_L3LD2_TD2, 
   I3LD_L3LD2_TD3, I3LD_L3LD2_TD4, I3LD_L3LD3_D1, I3LD_L3LD3_D2, 
   I3LD_L3LD3_R1, I3LD_L3LD3_R2, I3LD_L3LD3_TD1, I3LD_L3LD3_TD2, 
   I3LD_L3LD3_TD3, I3LD_L3LD3_TD4;

pmodel_t  

   I3LD_L3LD1_D5_DModel=PMODEL, I3LD_L3LD1_D6_DModel=PMODEL, I3LD_L3LD1_TD1_TDModel=PMODEL, 
   I3LD_L3LD1_TD2_TDModel=PMODEL, I3LD_L3LD1_TD3_TDModel=PMODEL, 
   I3LD_L3LD1_TD4_TDModel=PMODEL, I3LD_L3LD2_D1_DModel=PMODEL, 
   I3LD_L3LD2_D2_DModel=PMODEL, I3LD_L3LD2_TD1_TDModel=PMODEL, 
   I3LD_L3LD2_TD2_TDModel=PMODEL, I3LD_L3LD2_TD3_TDModel=PMODEL, I3LD_L3LD2_TD4_TDModel=PMODEL, 
   I3LD_L3LD3_D1_DModel=PMODEL, I3LD_L3LD3_D2_DModel=PMODEL, 
   I3LD_L3LD3_TD1_TDModel=PMODEL, I3LD_L3LD3_TD2_TDModel=PMODEL, 
   I3LD_L3LD3_TD3_TDModel=PMODEL, I3LD_L3LD3_TD4_TDModel=PMODEL;

//
   SF_NAME = "pwm_3LD_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 4 , 5 );
   A2 = am( 7 , 6 );
   LL1 = ind( 8 , 11 , p[1] , 0.0 );
   V1 = vsc( 4 , 0 , u[12]/2 );
   V2 = vsc( 0 , 6 , u[12]/2 );
   LL2 = ind( 9 , 12 , p[1] , 0.0 );
   LL3 = ind( 10 , 13 , p[1] , 0.0 );
   RL1 = res( 11 , 14 , p[0] );
   RL2 = res( 12 , 14 , p[0] );
   RL3 = res( 13 , 14 , p[0] );
   VL1 = vsc( 1 , 8 , u[13] );
   VL2 = vsc( 2 , 9 , u[14] );
   VL3 = vsc( 3 , 10 , u[15] );
   Va = vn( 1 );
   Vab = vnn( 1 , 2 );
   Vb = vn( 2 );
   Vc = vn( 3 );
//
// SUB-CIRCUIT DESCRIPTION
//


   xnode(k2, 2);
   I3LD_L3LD1_D5 = dpl( 0 , k2[0] , I3LD_L3LD1_D5_DModel );
   I3LD_L3LD1_D6 = dpl( k2[1] , 0 , I3LD_L3LD1_D6_DModel );
   I3LD_L3LD1_R1 = res( k2[0] , 1 , 1e4 );
   I3LD_L3LD1_R2 = res( 1 , k2[1] , 1e4 );
   I3LD_L3LD1_TD1 = igbtd( 5 , k2[0] , u[0] , I3LD_L3LD1_TD1_TDModel );
   I3LD_L3LD1_TD2 = igbtd( k2[0] , 1 , u[1] , I3LD_L3LD1_TD2_TDModel );
   I3LD_L3LD1_TD3 = igbtd( 1 , k2[1] , u[2] , I3LD_L3LD1_TD3_TDModel );
   I3LD_L3LD1_TD4 = igbtd( k2[1] , 7 , u[3] , I3LD_L3LD1_TD4_TDModel );


   xnode(k2, 2);
   I3LD_L3LD2_D1 = dpl( 0 , k2[0] , I3LD_L3LD2_D1_DModel );
   I3LD_L3LD2_D2 = dpl( k2[1] , 0 , I3LD_L3LD2_D2_DModel );
   I3LD_L3LD2_R1 = res( k2[0] , 2 , 1e4 );
   I3LD_L3LD2_R2 = res( 2 , k2[1] , 1e4 );
   I3LD_L3LD2_TD1 = igbtd( 5 , k2[0] , u[4] , I3LD_L3LD2_TD1_TDModel );
   I3LD_L3LD2_TD2 = igbtd( k2[0] , 2 , u[5] , I3LD_L3LD2_TD2_TDModel );
   I3LD_L3LD2_TD3 = igbtd( 2 , k2[1] , u[6] , I3LD_L3LD2_TD3_TDModel );
   I3LD_L3LD2_TD4 = igbtd( k2[1] , 7 , u[7] , I3LD_L3LD2_TD4_TDModel );


   xnode(k2, 2);
   I3LD_L3LD3_D1 = dpl( 0 , k2[0] , I3LD_L3LD3_D1_DModel );
   I3LD_L3LD3_D2 = dpl( k2[1] , 0 , I3LD_L3LD3_D2_DModel );
   I3LD_L3LD3_R1 = res( k2[0] , 3 , 1e4 );
   I3LD_L3LD3_R2 = res( 3 , k2[1] , 1e4 );
   I3LD_L3LD3_TD1 = igbtd( 5 , k2[0] , u[8] , I3LD_L3LD3_TD1_TDModel );
   I3LD_L3LD3_TD2 = igbtd( k2[0] , 3 , u[9] , I3LD_L3LD3_TD2_TDModel );
   I3LD_L3LD3_TD3 = igbtd( 3 , k2[1] , u[10] , I3LD_L3LD3_TD3_TDModel );
   I3LD_L3LD3_TD4 = igbtd( k2[1] , 7 , u[11] , I3LD_L3LD3_TD4_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=Vb.V;
   y[2]=Vc.V;
   y[3]=RL1.I;
   y[4]=RL2.I;
   y[5]=RL3.I;
   y[6]=Vab.V;
   y[7]=I3LD_L3LD1_TD1.I1;
   y[8]=I3LD_L3LD1_TD1.I2;
   y[9]=I3LD_L3LD1_TD1.V1;
   y[10]=I3LD_L3LD1_TD2.I1;
   y[11]=I3LD_L3LD1_TD2.I2;
   y[12]=I3LD_L3LD1_TD2.V1;
   y[13]=I3LD_L3LD1_D5.I;
   y[14]=I3LD_L3LD1_D5.V;
   y[15]=A1.I;
   y[16]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 3;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 3;
   YW[5] = 2;
   YW[6] = 2;
}
