// E:\simPE_MPI8b_OS\OpenSource\pwm_3LT_3PH_VLR_OS.c

//
static void pwm_3LT_3PH_VLR_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, LL1, V1, V2, LL2, LL3, RL1, RL2, RL3, VL1, VL2, VL3, Va, Vab, Vb, 
   Vc,
   I3LT_L3LT1_TD1, I3LT_L3LT1_TD2, I3LT_L3LT1_TD3, I3LT_L3LT1_TD4, I3LT_L3LT2_TD1, 
   I3LT_L3LT2_TD2, I3LT_L3LT2_TD3, I3LT_L3LT2_TD4, I3LT_L3LT_TD1, 
   I3LT_L3LT_TD2, I3LT_L3LT_TD3, I3LT_L3LT_TD4;

pmodel_t  

   I3LT_L3LT1_TD1_TDModel=PMODEL, I3LT_L3LT1_TD2_TDModel=PMODEL, I3LT_L3LT1_TD3_TDModel=PMODEL, 
   I3LT_L3LT1_TD4_TDModel=PMODEL, I3LT_L3LT2_TD1_TDModel=PMODEL, 
   I3LT_L3LT2_TD2_TDModel=PMODEL, I3LT_L3LT2_TD3_TDModel=PMODEL, 
   I3LT_L3LT2_TD4_TDModel=PMODEL, I3LT_L3LT_TD1_TDModel=PMODEL, 
   I3LT_L3LT_TD2_TDModel=PMODEL, I3LT_L3LT_TD3_TDModel=PMODEL, 
   I3LT_L3LT_TD4_TDModel=PMODEL;

//
   SF_NAME = "pwm_3LT_3PH_VLR_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 4 , 5 );
   A2 = am( 7 , 6 );
   LL1 = ind( 8 , 11 , p[1] , 0.0 );
   V1 = vsc( 4 , 0 , u[12]/2 );
   V2 = vsc( 0 , 6 , u[12]/2 );
   LL2 = ind( 9 , 12 , p[1] , 0.0 );
   LL3 = ind( 10 , 13 , p[1] , 0.0 );
   RL1 = res( 11 , 14 , p[0] );
   RL2 = res( 12 , 14 , p[0] );
   RL3 = res( 13 , 14 , p[0] );
   VL1 = vsc( 1 , 8 , u[13] );
   VL2 = vsc( 2 , 9 , u[14] );
   VL3 = vsc( 3 , 10 , u[15] );
   Va = vn( 1 );
   Vab = vnn( 1 , 2 );
   Vb = vn( 2 );
   Vc = vn( 3 );
//
// SUB-CIRCUIT DESCRIPTION
//


   xnode(k2, 1);
   I3LT_L3LT1_TD1 = igbtd( 5 , 2 , u[4] , I3LT_L3LT1_TD1_TDModel );
   I3LT_L3LT1_TD2 = igbtd( 0 , k2[0] , u[5] , I3LT_L3LT1_TD2_TDModel );
   I3LT_L3LT1_TD3 = igbtd( 2 , k2[0] , u[6] , I3LT_L3LT1_TD3_TDModel );
   I3LT_L3LT1_TD4 = igbtd( 2 , 7 , u[7] , I3LT_L3LT1_TD4_TDModel );


   xnode(k2, 1);
   I3LT_L3LT2_TD1 = igbtd( 5 , 3 , u[8] , I3LT_L3LT2_TD1_TDModel );
   I3LT_L3LT2_TD2 = igbtd( 0 , k2[0] , u[9] , I3LT_L3LT2_TD2_TDModel );
   I3LT_L3LT2_TD3 = igbtd( 3 , k2[0] , u[10] , I3LT_L3LT2_TD3_TDModel );
   I3LT_L3LT2_TD4 = igbtd( 3 , 7 , u[11] , I3LT_L3LT2_TD4_TDModel );


   xnode(k2, 1);
   I3LT_L3LT_TD1 = igbtd( 5 , 1 , u[0] , I3LT_L3LT_TD1_TDModel );
   I3LT_L3LT_TD2 = igbtd( 0 , k2[0] , u[1] , I3LT_L3LT_TD2_TDModel );
   I3LT_L3LT_TD3 = igbtd( 1 , k2[0] , u[2] , I3LT_L3LT_TD3_TDModel );
   I3LT_L3LT_TD4 = igbtd( 1 , 7 , u[3] , I3LT_L3LT_TD4_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=Vb.V;
   y[2]=Vc.V;
   y[3]=RL1.I;
   y[4]=RL2.I;
   y[5]=RL3.I;
   y[6]=Vab.V;
   y[7]=I3LT_L3LT_TD1.I1;
   y[8]=I3LT_L3LT_TD1.I2;
   y[9]=I3LT_L3LT_TD1.V1;
   y[10]=I3LT_L3LT_TD2.I1;
   y[11]=I3LT_L3LT_TD2.I2;
   y[12]=I3LT_L3LT_TD2.V1;
   y[13]=A1.I;
   y[14]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 3;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 3;
   YW[5] = 2;
}
