// E:\simPE_MPI8b_OS\OpenSource\pwm_3LT_FB_VLR_OS.c

//
static void pwm_3LT_FB_VLR_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, V1, V2, LL1, RL1, VL1, Va, Vab,
   B3LT_L3LT1_TD1, B3LT_L3LT1_TD2, B3LT_L3LT1_TD3, B3LT_L3LT1_TD4, B3LT_L3LT_TD1, 
   B3LT_L3LT_TD2, B3LT_L3LT_TD3, B3LT_L3LT_TD4;

pmodel_t  

   B3LT_L3LT1_TD1_TDModel=PMODEL, B3LT_L3LT1_TD2_TDModel=PMODEL, B3LT_L3LT1_TD3_TDModel=PMODEL, 
   B3LT_L3LT1_TD4_TDModel=PMODEL, B3LT_L3LT_TD1_TDModel=PMODEL, 
   B3LT_L3LT_TD2_TDModel=PMODEL, B3LT_L3LT_TD3_TDModel=PMODEL, 
   B3LT_L3LT_TD4_TDModel=PMODEL;

//
   SF_NAME = "pwm_3LT_FB_VLR_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 3 , 4 );
   A2 = am( 6 , 5 );
   V1 = vsc( 3 , 0 , u[8]/2 );
   V2 = vsc( 0 , 5 , u[8]/2 );
   LL1 = ind( 7 , 8 , p[1] , 0.0 );
   RL1 = res( 2 , 8 , p[0] );
   VL1 = vsc( 1 , 7 , u[9] );
   Va = vn( 1 );
   Vab = vnn( 1 , 2 );
//
// SUB-CIRCUIT DESCRIPTION
//


   xnode(k2, 1);
   B3LT_L3LT1_TD1 = igbtd( 4 , 2 , u[4] , B3LT_L3LT1_TD1_TDModel );
   B3LT_L3LT1_TD2 = igbtd( 0 , k2[0] , u[5] , B3LT_L3LT1_TD2_TDModel );
   B3LT_L3LT1_TD3 = igbtd( 2 , k2[0] , u[6] , B3LT_L3LT1_TD3_TDModel );
   B3LT_L3LT1_TD4 = igbtd( 2 , 6 , u[7] , B3LT_L3LT1_TD4_TDModel );


   xnode(k2, 1);
   B3LT_L3LT_TD1 = igbtd( 4 , 1 , u[0] , B3LT_L3LT_TD1_TDModel );
   B3LT_L3LT_TD2 = igbtd( 0 , k2[0] , u[1] , B3LT_L3LT_TD2_TDModel );
   B3LT_L3LT_TD3 = igbtd( 1 , k2[0] , u[2] , B3LT_L3LT_TD3_TDModel );
   B3LT_L3LT_TD4 = igbtd( 1 , 6 , u[3] , B3LT_L3LT_TD4_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=RL1.I;
   y[2]=Vab.V;
   y[3]=B3LT_L3LT_TD1.I1;
   y[4]=B3LT_L3LT_TD1.I2;
   y[5]=B3LT_L3LT_TD1.V1;
   y[6]=B3LT_L3LT_TD2.I1;
   y[7]=B3LT_L3LT_TD2.I2;
   y[8]=B3LT_L3LT_TD2.V1;
   y[9]=A1.I;
   y[10]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 3;
   YW[5] = 2;
}
