// E:\simPE_MPI8b_OS\OpenSource\pwm_3LT_HB_IS_OS.c

//
static void pwm_3LT_HB_IS_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, I1, V1, V2, Va,
   L3LT1_TD1, L3LT1_TD2, L3LT1_TD3, L3LT1_TD4;

pmodel_t  

   L3LT1_TD1_TDModel=PMODEL, L3LT1_TD2_TDModel=PMODEL, L3LT1_TD3_TDModel=PMODEL, 
   L3LT1_TD4_TDModel=PMODEL;

//
   SF_NAME = "pwm_3LT_HB_IS_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 2 , 3 );
   A2 = am( 5 , 4 );
   I1 = isc( 1 , 0 , u[5] );
   V1 = vsc( 2 , 0 , u[4]/2 );
   V2 = vsc( 0 , 4 , u[4]/2 );
   Va = vn( 1 );
//
// SUB-CIRCUIT DESCRIPTION
//
   xnode(k1, 1);
   L3LT1_TD1 = igbtd( 3 , 1 , u[0] , L3LT1_TD1_TDModel );
   L3LT1_TD2 = igbtd( 0 , k1[0] , u[1] , L3LT1_TD2_TDModel );
   L3LT1_TD3 = igbtd( 1 , k1[0] , u[2] , L3LT1_TD3_TDModel );
   L3LT1_TD4 = igbtd( 1 , 5 , u[3] , L3LT1_TD4_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=I1.I;
   y[2]=L3LT1_TD1.I1;
   y[3]=L3LT1_TD1.I2;
   y[4]=L3LT1_TD1.V1;
   y[5]=L3LT1_TD2.I1;
   y[6]=L3LT1_TD2.I2;
   y[7]=L3LT1_TD2.V1;
   y[8]=A1.I;
   y[9]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 3;
   YW[3] = 3;
   YW[4] = 2;
}
