// E:\simPE_MPI8b_OS\OpenSource\pwm_4LC_3PH_IS_OS.c

//
static void pwm_4LC_3PH_IS_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, Ia, Ib, Ic, V1, V2, Va, Vab, Vb, Vc,
   I4LC_L4LC1_C1, I4LC_L4LC1_C2, I4LC_L4LC1_TD1, I4LC_L4LC1_TD2, I4LC_L4LC1_TD3, 
   I4LC_L4LC1_TD4, I4LC_L4LC1_TD5, I4LC_L4LC1_TD6, I4LC_L4LC2_C1, 
   I4LC_L4LC2_C2, I4LC_L4LC2_TD1, I4LC_L4LC2_TD2, I4LC_L4LC2_TD3, 
   I4LC_L4LC2_TD4, I4LC_L4LC2_TD5, I4LC_L4LC2_TD6, I4LC_L4LC3_C1, I4LC_L4LC3_C2, 
   I4LC_L4LC3_TD1, I4LC_L4LC3_TD2, I4LC_L4LC3_TD3, I4LC_L4LC3_TD4, 
   I4LC_L4LC3_TD5, I4LC_L4LC3_TD6;

pmodel_t  

   I4LC_L4LC1_TD1_TDModel=PMODEL, I4LC_L4LC1_TD2_TDModel=PMODEL, I4LC_L4LC1_TD3_TDModel=PMODEL, 
   I4LC_L4LC1_TD4_TDModel=PMODEL, I4LC_L4LC1_TD5_TDModel=PMODEL, 
   I4LC_L4LC1_TD6_TDModel=PMODEL, I4LC_L4LC2_TD1_TDModel=PMODEL, 
   I4LC_L4LC2_TD2_TDModel=PMODEL, I4LC_L4LC2_TD3_TDModel=PMODEL, 
   I4LC_L4LC2_TD4_TDModel=PMODEL, I4LC_L4LC2_TD5_TDModel=PMODEL, 
   I4LC_L4LC2_TD6_TDModel=PMODEL, I4LC_L4LC3_TD1_TDModel=PMODEL, 
   I4LC_L4LC3_TD2_TDModel=PMODEL, I4LC_L4LC3_TD3_TDModel=PMODEL, I4LC_L4LC3_TD4_TDModel=PMODEL, 
   I4LC_L4LC3_TD5_TDModel=PMODEL, I4LC_L4LC3_TD6_TDModel=PMODEL;

//
   SF_NAME = "pwm_4LC_3PH_IS_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 5 , 6 );
   A2 = am( 8 , 7 );
   Ia = isc( 1 , 3 , u[19] );
   Ib = isc( 2 , 3 , u[20] );
   Ic = am( 4 , 3 );
   V1 = vsc( 5 , 0 , u[18]/2 );
   V2 = vsc( 0 , 7 , u[18]/2 );
   Va = vn( 1 );
   Vab = vnn( 1 , 2 );
   Vb = vn( 2 );
   Vc = vn( 4 );
//
// SUB-CIRCUIT DESCRIPTION
//


   xnode(k2, 4);
   I4LC_L4LC1_C1 = cap( k2[0] , k2[3] , p[0] , p[1] );
   I4LC_L4LC1_C2 = cap( k2[1] , k2[2] , p[2] , p[3] );
   I4LC_L4LC1_TD1 = igbtd( 6 , k2[0] , u[0] , I4LC_L4LC1_TD1_TDModel );
   I4LC_L4LC1_TD2 = igbtd( k2[0] , k2[1] , u[1] , I4LC_L4LC1_TD2_TDModel );
   I4LC_L4LC1_TD3 = igbtd( k2[1] , 1 , u[2] , I4LC_L4LC1_TD3_TDModel );
   I4LC_L4LC1_TD4 = igbtd( 1 , k2[2] , u[3] , I4LC_L4LC1_TD4_TDModel );
   I4LC_L4LC1_TD5 = igbtd( k2[2] , k2[3] , u[4] , I4LC_L4LC1_TD5_TDModel );
   I4LC_L4LC1_TD6 = igbtd( k2[3] , 8 , u[5] , I4LC_L4LC1_TD6_TDModel );


   xnode(k2, 4);
   I4LC_L4LC2_C1 = cap( k2[0] , k2[3] , p[0] , p[1] );
   I4LC_L4LC2_C2 = cap( k2[1] , k2[2] , p[2] , p[3] );
   I4LC_L4LC2_TD1 = igbtd( 6 , k2[0] , u[6] , I4LC_L4LC2_TD1_TDModel );
   I4LC_L4LC2_TD2 = igbtd( k2[0] , k2[1] , u[7] , I4LC_L4LC2_TD2_TDModel );
   I4LC_L4LC2_TD3 = igbtd( k2[1] , 2 , u[8] , I4LC_L4LC2_TD3_TDModel );
   I4LC_L4LC2_TD4 = igbtd( 2 , k2[2] , u[9] , I4LC_L4LC2_TD4_TDModel );
   I4LC_L4LC2_TD5 = igbtd( k2[2] , k2[3] , u[10] , I4LC_L4LC2_TD5_TDModel );
   I4LC_L4LC2_TD6 = igbtd( k2[3] , 8 , u[11] , I4LC_L4LC2_TD6_TDModel );


   xnode(k2, 4);
   I4LC_L4LC3_C1 = cap( k2[0] , k2[3] , p[0] , p[1] );
   I4LC_L4LC3_C2 = cap( k2[1] , k2[2] , p[2] , p[3] );
   I4LC_L4LC3_TD1 = igbtd( 6 , k2[0] , u[12] , I4LC_L4LC3_TD1_TDModel );
   I4LC_L4LC3_TD2 = igbtd( k2[0] , k2[1] , u[13] , I4LC_L4LC3_TD2_TDModel );
   I4LC_L4LC3_TD3 = igbtd( k2[1] , 4 , u[14] , I4LC_L4LC3_TD3_TDModel );
   I4LC_L4LC3_TD4 = igbtd( 4 , k2[2] , u[15] , I4LC_L4LC3_TD4_TDModel );
   I4LC_L4LC3_TD5 = igbtd( k2[2] , k2[3] , u[16] , I4LC_L4LC3_TD5_TDModel );
   I4LC_L4LC3_TD6 = igbtd( k2[3] , 8 , u[17] , I4LC_L4LC3_TD6_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=Vb.V;
   y[2]=Vc.V;
   y[3]=Ia.I;
   y[4]=Ib.I;
   y[5]=Ic.I;
   y[6]=Vab.V;
   y[7]=I4LC_L4LC1_TD1.I1;
   y[8]=I4LC_L4LC1_TD1.I2;
   y[9]=I4LC_L4LC1_TD1.V1;
   y[10]=I4LC_L4LC1_TD2.I1;
   y[11]=I4LC_L4LC1_TD2.I2;
   y[12]=I4LC_L4LC1_TD2.V1;
   y[13]=I4LC_L4LC1_TD3.I1;
   y[14]=I4LC_L4LC1_TD3.I2;
   y[15]=I4LC_L4LC1_TD3.V1;
   y[16]=A1.I;
   y[17]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 3;
   YW[1] = 3;
   YW[2] = 1;
   YW[3] = 3;
   YW[4] = 3;
   YW[5] = 3;
   YW[6] = 2;
}
