// E:\simPE_MPI8b_OS\OpenSource\pwm_4LC_HB_IS_OS.c

//
static void pwm_4LC_HB_IS_OS (double *u, double *y, double *p)
{
// DECLARATION
//
ostruct_t  
   A1, A2, Ia, V1, V2, Va,
   I4LC_L4LC1_C1, I4LC_L4LC1_C2, I4LC_L4LC1_TD1, I4LC_L4LC1_TD2, I4LC_L4LC1_TD3, 
   I4LC_L4LC1_TD4, I4LC_L4LC1_TD5, I4LC_L4LC1_TD6;

pmodel_t  

   I4LC_L4LC1_TD1_TDModel=PMODEL, I4LC_L4LC1_TD2_TDModel=PMODEL, I4LC_L4LC1_TD3_TDModel=PMODEL, 
   I4LC_L4LC1_TD4_TDModel=PMODEL, I4LC_L4LC1_TD5_TDModel=PMODEL, 
   I4LC_L4LC1_TD6_TDModel=PMODEL;

//
   SF_NAME = "pwm_4LC_HB_IS_OS" ;
//
// CIRCUIT DESCRIPTION
//
   A1 = am( 2 , 3 );
   A2 = am( 5 , 4 );
   Ia = isc( 1 , 0 , u[7] );
   V1 = vsc( 2 , 0 , u[6]/2 );
   V2 = vsc( 0 , 4 , u[6]/2 );
   Va = vn( 1 );
//
// SUB-CIRCUIT DESCRIPTION
//


   xnode(k2, 4);
   I4LC_L4LC1_C1 = cap( k2[0] , k2[3] , p[0] , p[1] );
   I4LC_L4LC1_C2 = cap( k2[1] , k2[2] , p[2] , p[3] );
   I4LC_L4LC1_TD1 = igbtd( 3 , k2[0] , u[0] , I4LC_L4LC1_TD1_TDModel );
   I4LC_L4LC1_TD2 = igbtd( k2[0] , k2[1] , u[1] , I4LC_L4LC1_TD2_TDModel );
   I4LC_L4LC1_TD3 = igbtd( k2[1] , 1 , u[2] , I4LC_L4LC1_TD3_TDModel );
   I4LC_L4LC1_TD4 = igbtd( 1 , k2[2] , u[3] , I4LC_L4LC1_TD4_TDModel );
   I4LC_L4LC1_TD5 = igbtd( k2[2] , k2[3] , u[4] , I4LC_L4LC1_TD5_TDModel );
   I4LC_L4LC1_TD6 = igbtd( k2[3] , 5 , u[5] , I4LC_L4LC1_TD6_TDModel );


//
// OUTPUT
//
   y[0]=Va.V;
   y[1]=Ia.I;
   y[2]=I4LC_L4LC1_TD1.I1;
   y[3]=I4LC_L4LC1_TD1.I2;
   y[4]=I4LC_L4LC1_TD1.V1;
   y[5]=I4LC_L4LC1_TD2.I1;
   y[6]=I4LC_L4LC1_TD2.I2;
   y[7]=I4LC_L4LC1_TD2.V1;
   y[8]=I4LC_L4LC1_TD3.I1;
   y[9]=I4LC_L4LC1_TD3.I2;
   y[10]=I4LC_L4LC1_TD3.V1;
   y[11]=A1.I;
   y[12]=A2.I;
//
// OUTPUT PORTS WIDTH
//
   
   YW[0] = 1;
   YW[1] = 1;
   YW[2] = 3;
   YW[3] = 3;
   YW[4] = 3;
   YW[5] = 2;
}
